/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.MemoryUsage;
import java.util.Set;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;

public class GarbageCollectionStats {
    private final double rate;
    private final long used;
    private final long max;
    private final long eventCount;

    public GarbageCollectionStats(Set<GarbageCollectionEvent> events) {
        this.rate = GarbageCollectionStats.calculateRate(events);
        this.used = GarbageCollectionStats.calculateAverageUsage(events);
        this.max = GarbageCollectionStats.calculateMaxSize(events);
        this.eventCount = events.size();
    }

    static double calculateRate(Set<GarbageCollectionEvent> events) {
        long firstGC = 0L;
        long lastGC = 0L;
        long firstCount = 0L;
        long lastCount = 0L;
        for (GarbageCollectionEvent event : events) {
            if (event.getCount() == lastCount || event.getCount() == 0L) continue;
            lastCount = event.getCount();
            if (firstGC == 0L) {
                firstGC = event.getTimestamp();
                firstCount = event.getCount();
                continue;
            }
            lastGC = event.getTimestamp();
        }
        if (events.size() < 2 || lastCount == 0L) {
            return 0.0;
        }
        long elapsed = lastGC - firstGC;
        long totalCount = lastCount - firstCount;
        return (double)totalCount / (double)elapsed * 1000.0;
    }

    static long calculateAverageUsage(Set<GarbageCollectionEvent> events) {
        if (events.size() < 1) {
            return -1L;
        }
        long total = 0L;
        long firstCount = 0L;
        long lastCount = 0L;
        for (GarbageCollectionEvent event : events) {
            if (event.getCount() == lastCount || event.getCount() == 0L) continue;
            MemoryUsage usage = event.getUsage();
            if (firstCount == 0L) {
                firstCount = event.getCount();
                total += usage.getUsed();
            } else {
                total += usage.getUsed() * (event.getCount() - lastCount);
            }
            lastCount = event.getCount();
        }
        if (lastCount == 0L || lastCount == firstCount) {
            return -1L;
        }
        long totalCount = lastCount - firstCount + 1L;
        return total / totalCount;
    }

    static long calculateMaxSize(Set<GarbageCollectionEvent> events) {
        if (events.size() < 1) {
            return -1L;
        }
        MemoryUsage usage = events.iterator().next().getUsage();
        return usage.getMax();
    }

    public double getRate() {
        return this.rate;
    }

    public int getUsage() {
        if (this.used > 0L && this.max > 0L) {
            return NumberUtil.percentOf(this.used, this.max);
        }
        return -1;
    }

    public double getUsed() {
        return this.used;
    }

    public long getMax() {
        return this.max;
    }

    public long getEventCount() {
        return this.eventCount;
    }
}

