/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.PairConsumer;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.OutboundSemiGraph;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;
    private static final Set<Integer> ourNonTransactedTraces;

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(0);
        }
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element);
        assert (node != null) : element;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root2, boolean skipWhitespaces) {
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, false, false, true);
        return buffer.toString();
    }

    public static String nodeTreeToString(@NotNull ASTNode root2, boolean skipWhitespaces) {
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(2);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, false, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root2, boolean skipWhitespaces, boolean showRanges) {
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, showRanges, false, true);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(4);
        }
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(5);
        }
        DebugUtil.treeToBuffer(buffer, root2, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, @Nullable PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(6);
        }
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(7);
        }
        ((TreeElement)root2).acceptTree(new TreeToBuffer(buffer, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, extra));
    }

    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        if (tree == null) {
            DebugUtil.$$$reportNull$$$0(8);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), buffer, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        if (tree == null) {
            DebugUtil.$$$reportNull$$$0(9);
        }
        if (node == null) {
            DebugUtil.$$$reportNull$$$0(10);
        }
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(11);
        }
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text2 = ((LighterASTTokenNode)node).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref<T[]> kids = new Ref<T[]>();
                int numKids = tree.getChildren(node, kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                } else {
                    for (int i = 0; i < numKids; ++i) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String stubTreeToString(Stub root2) {
        StringBuilder builder = new StringBuilder();
        DebugUtil.stubTreeToBuffer(root2, builder, 0);
        return builder.toString();
    }

    public static void stubTreeToBuffer(Stub node, Appendable buffer, int indent) {
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List<? extends Stub> children2 = node.getChildrenStubs();
            for (Stub stub : children2) {
                DebugUtil.stubTreeToBuffer(stub, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root2 = anyElement;
        while (root2.getTreeParent() != null) {
            root2 = root2.getTreeParent();
        }
        if (root2 instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root2);
        }
    }

    private static void checkSubtree(CompositeElement root2) {
        if (root2.rawFirstChild() == null) {
            if (root2.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root2, "firstChild == null, but lastChild != null");
            }
        } else {
            for (ASTNode child = root2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child);
                }
                if (child.getTreeParent() != root2) {
                    throw new IncorrectTreeStructureException(child, "child has wrong parent value");
                }
                if (child == root2.getFirstChildNode()) {
                    if (child.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root2, "firstChild.prev != null");
                    }
                } else {
                    if (child.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child, "not first child has prev == null");
                    }
                    if (child.getTreePrev().getTreeNext() != child) {
                        throw new IncorrectTreeStructureException(child, "element.prev.next != element");
                    }
                }
                if (child.getTreeNext() != null || root2.getLastChildNode() == child) continue;
                throw new IncorrectTreeStructureException(child, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        ASTNode treeParent;
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(12);
        }
        if ((treeParent = element.getTreeParent()) == null) {
            return;
        }
        ASTNode[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find(elements, element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        CharTable fromCharTab;
        if (element1 == null) {
            DebugUtil.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(14);
        }
        LOG.assertTrue((fromCharTab = SharedImplUtil.findCharTableByTree(element1)) == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(15);
        }
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root2, boolean skipWhiteSpaces, boolean showRanges) {
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(16);
        }
        return DebugUtil.psiToString(root2, skipWhiteSpaces, showRanges, null);
    }

    public static String psiToString(@NotNull PsiElement root2, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(17);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.psiToBuffer(buffer, root2, skipWhiteSpaces, showRanges, extra);
        return buffer.toString();
    }

    @NotNull
    public static String psiToStringIgnoringNonCode(@NotNull PsiElement element) {
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(18);
        }
        StringBuilder buffer = new StringBuilder();
        ((TreeElement)element.getNode()).acceptTree(new TreeToBuffer((Appendable)buffer, 0, true, false, false, false, null){

            @Override
            protected boolean shouldSkipNode(TreeElement node) {
                return super.shouldSkipNode(node) || node instanceof PsiErrorElement || node instanceof PsiComment || node instanceof LeafPsiElement && StringUtil.isEmptyOrSpaces(node.getText()) || node instanceof OuterLanguageElement;
            }

            @Override
            protected boolean showEmptyChildren() {
                return false;
            }
        });
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root2, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node = root2.getNode();
        if (node == null) {
            DebugUtil.psiToBuffer(buffer, root2, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(20);
        }
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(21);
        }
        DebugUtil.psiToBuffer(buffer, root2, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(22);
        }
        if (root2 == null) {
            DebugUtil.$$$reportNull$$$0(23);
        }
        if (skipWhiteSpaces && root2 instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            buffer.append(root2.toString());
            PsiElement child = root2.getFirstChild();
            if (child == null) {
                String text2 = root2.getText();
                assert (text2 != null) : "text is null for <" + root2 + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            if (showRanges) {
                buffer.append(root2.getTextRange().toString());
            }
            buffer.append("\n");
            while (child != null) {
                DebugUtil.psiToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child = child.getNextSibling();
            }
            if (extra != null) {
                extra.consume(root2, element -> {
                    if (buffer == null) {
                        DebugUtil.$$$reportNull$$$0(39);
                    }
                    DebugUtil.psiToBuffer(buffer, element, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null);
                });
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String fixWhiteSpaces(String text2) {
        text2 = StringUtil.replace(text2, "\n", "\\n");
        text2 = StringUtil.replace(text2, "\r", "\\r");
        text2 = StringUtil.replace(text2, "\t", "\\t");
        return text2;
    }

    public static String currentStackTrace() {
        return ExceptionUtil.currentStackTrace();
    }

    public static void startPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    public static void finishPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static <T extends Throwable> void performPsiModification(String trace, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            DebugUtil.$$$reportNull$$$0(24);
        }
        DebugUtil.startPsiModification(trace);
        try {
            runnable.run();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static <T, E extends Throwable> T performPsiModification(String trace, @NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            DebugUtil.$$$reportNull$$$0(25);
        }
        DebugUtil.startPsiModification(trace);
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        Object trace;
        if (treeElement == null) {
            DebugUtil.$$$reportNull$$$0(26);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(treeElement)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(treeElement, trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        Object trace;
        if (o == null) {
            DebugUtil.$$$reportNull$$$0(27);
        }
        if ((trace = PsiInvalidElementAccessException.getInvalidationTrace(o)) != null) {
            return;
        }
        PsiInvalidElementAccessException.setInvalidationTrace(o, DebugUtil.currentInvalidationTrace());
    }

    public static void onInvalidated(@NotNull FileViewProvider provider) {
        Object trace;
        if (provider == null) {
            DebugUtil.$$$reportNull$$$0(28);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(null)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(provider, trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace(treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @NotNull
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        if (trace == null && ourNonTransactedTraces.add(ExceptionUtil.getThrowableText((Throwable)(trace = new Throwable())).hashCode())) {
            LOG.info("PSI invalidated outside transaction", (Throwable)trace);
        }
        Object object = trace;
        if (object == null) {
            DebugUtil.$$$reportNull$$$0(29);
        }
        return object;
    }

    public static void revalidateNode(@NotNull ASTNode element) {
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(30);
        }
        PsiInvalidElementAccessException.setInvalidationTrace(element, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep(millis);
    }

    public static void checkTreeStructure(ASTNode element) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        if (element == null) {
            DebugUtil.$$$reportNull$$$0(31);
        }
        if (document == null) {
            DebugUtil.$$$reportNull$$$0(32);
        }
        PsiUtilCore.ensureValid(element);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            String string = "no file for " + element + " of " + element.getClass();
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        PsiUtilCore.ensureValid(file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(file2.getProject());
        Document actualDocument = manager.getDocument(file2);
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            String string = "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        PsiFile cachedPsiFile = manager.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            String string = "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        if (!manager.isCommitted(document)) {
            String string = "not committed document " + document + ", " + fileDiagnostics;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            String string = "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = "unknown inconsistency in " + fileDiagnostics;
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static <T> String graphToString(InboundSemiGraph<T> graph2) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getIn(node), 0, new HashSet(), buffer);
        return buffer.toString();
    }

    public static <T> String graphToString(OutboundSemiGraph<T> graph2) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getOut(node), 0, new HashSet(), buffer);
        return buffer.toString();
    }

    private static <T> void printNodes(Iterator<T> nodes, Function<T, Iterator<T>> getter2, int indent, Set<T> visited2, StringBuilder buffer) {
        while (nodes.hasNext()) {
            T node = nodes.next();
            StringUtil.repeatSymbol(buffer, ' ', indent);
            buffer.append(node);
            if (visited2.add(node)) {
                buffer.append('\n');
                DebugUtil.printNodes(getter2.fun(node), getter2, indent + 2, visited2, buffer);
                continue;
            }
            buffer.append(" [...]\n");
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
        ourNonTransactedTraces = ContainerUtil.newConcurrentSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 20: 
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "psiToStringIgnoringNonCode";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "currentInvalidationTrace";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "diagnosePsiDocumentInconsistency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiTreeToString";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "treeToString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nodeTreeToString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "treeToBuffer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToString";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToBuffer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkParentChildConsistent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSameCharTabs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "psiToString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "psiToStringIgnoringNonCode";
                break;
            }
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "psiToBuffer";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performPsiModification";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onInvalidated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "revalidateNode";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "diagnosePsiDocumentInconsistency";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$psiToBuffer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    private static class TreeToBuffer
    extends RecursiveTreeElementWalkingVisitor {
        final Appendable buffer;
        final boolean skipWhiteSpaces;
        final boolean showRanges;
        final boolean showChildrenRanges;
        final boolean usePsi;
        final PairConsumer<PsiElement, Consumer<PsiElement>> extra;
        int indent;

        TreeToBuffer(Appendable buffer, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
            this.buffer = buffer;
            this.skipWhiteSpaces = skipWhiteSpaces;
            this.showRanges = showRanges;
            this.showChildrenRanges = showChildrenRanges;
            this.usePsi = usePsi;
            this.extra = extra;
            this.indent = indent;
        }

        @Override
        protected void visitNode(TreeElement root2) {
            if (this.shouldSkipNode(root2)) {
                this.indent += 2;
                return;
            }
            StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
            try {
                if (root2 instanceof CompositeElement) {
                    if (this.usePsi) {
                        PsiElement psiElement = root2.getPsi();
                        if (psiElement != null) {
                            this.buffer.append(psiElement.toString());
                        } else {
                            this.buffer.append(root2.getElementType().toString());
                        }
                    } else {
                        this.buffer.append(root2.toString());
                    }
                } else {
                    String text2 = DebugUtil.fixWhiteSpaces(root2.getText());
                    this.buffer.append(root2.toString()).append("('").append(text2).append("')");
                }
                if (this.showRanges) {
                    this.buffer.append(root2.getTextRange().toString());
                }
                this.buffer.append("\n");
                this.indent += 2;
                if (root2 instanceof CompositeElement && root2.getFirstChildNode() == null && this.showEmptyChildren()) {
                    StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
                    this.buffer.append("<empty list>\n");
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
            super.visitNode(root2);
        }

        protected boolean showEmptyChildren() {
            return true;
        }

        protected boolean shouldSkipNode(TreeElement node) {
            return this.skipWhiteSpaces && node.getElementType() == TokenType.WHITE_SPACE;
        }

        @Override
        protected void elementFinished(@NotNull ASTNode e) {
            PsiElement psiElement;
            if (e == null) {
                TreeToBuffer.$$$reportNull$$$0(0);
            }
            PsiElement psiElement2 = psiElement = this.extra != null && this.usePsi && e instanceof CompositeElement ? e.getPsi() : null;
            if (psiElement != null) {
                this.extra.consume(psiElement, element -> DebugUtil.treeToBuffer(this.buffer, element.getNode(), this.indent, this.skipWhiteSpaces, this.showRanges, this.showChildrenRanges, true, null));
            }
            this.indent -= 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil$TreeToBuffer", "elementFinished"));
        }
    }
}

