/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $receiver, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        Object object;
        Object suggestedName;
        Object object2;
        Object paramNameForType;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(targetList2, (String)"targetList");
        Map aliases = new LinkedHashMap();
        Iterator<TypeParameterDescriptor> iterator2 = FunctionTranslatorKt.getCorrectTypeParameters(descriptor2).iterator();
        while (iterator2.hasNext()) {
            JsNameRef jsNameRef;
            JsName paramName;
            TypeParameterDescriptor type2;
            TypeParameterDescriptor typeParameterDescriptor = type2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"type");
            if (!typeParameterDescriptor.isReified()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getNameForDescriptor(type2), (String)"getNameForDescriptor(type)");
            object3 = targetList2;
            object2 = new JsParameter((JsName)paramNameForType);
            object3.add(object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)Namer.isInstanceSuggestedName(type2), (String)"Namer.isInstanceSuggestedName(type)");
            Intrinsics.checkExpressionValueIsNotNull((Object)JsScope.declareTemporaryName((String)suggestedName), (String)"JsScope.declareTemporaryName(suggestedName)");
            object = targetList2;
            Object object4 = new JsParameter(paramName);
            object.add(object4);
            object = aliases;
            object4 = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)paramName.makeRef(), (String)"paramName.makeRef()");
            object.put(object4, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName receiverParameterName = jsName;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"receiverParameterName.makeRef()");
            JsNameRef receiverRef = jsNameRef;
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"descriptor.extensionReceiverParameter!!");
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            paramNameForType = aliases;
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor2, (String)"descriptor.extensionReceiverParameter!!");
            suggestedName = receiverParameterDescriptor2;
            object2 = receiverRef;
            paramNameForType.put(suggestedName, object2);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsNameRef $i$a$1$also;
            HasMetadata tmpName;
            HasMetadata it;
            JsName name;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getNameForDescriptor(valueParameter), (String)"getNameForDescriptor(valueParameter)");
            object2 = JsScope.declareTemporaryName(name.getIdent());
            HasMetadata hasMetadata = it = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)hasMetadata, (String)"it");
            MetadataProperties.setDescriptor((JsName)hasMetadata, (DeclarationDescriptor)valueParameter);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"JsScope.declareTemporary\u2026riptor = valueParameter }");
            object2 = aliases;
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueParameter");
            object = valueParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)JsAstUtils.pureFqn((JsName)tmpName, null), (String)"JsAstUtils.pureFqn(tmpName, null)");
            object2.put(object, $i$a$1$also);
            object2 = targetList2;
            Object $receiver2 = object = new JsParameter((JsName)tmpName);
            MetadataProperties.setHasDefaultValue((JsParameter)$receiver2, ArgumentsUtilsKt.hasDefaultValue(valueParameter));
            object2.add(object);
        }
        ValueParameterDescriptor continuationDescriptor = $receiver.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($receiver.getNameForDescriptor(continuationDescriptor));
            Object object5 = targetList2;
            object5.add(jsParameter);
            object5 = aliases;
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"JsAstUtils.stateMachineReceiver()");
            object3 = jsExpression;
            object5.put(continuationDescriptor, object3);
        }
        TranslationContext translationContext = $receiver.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(@NotNull FunctionDescriptor $receiver) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $receiver.getTypeParameters();
        }
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"(this as? PropertyAccess\u2026ameters ?: typeParameters");
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(@NotNull FunctionDescriptor $receiver) {
        return DescriptorUtils.isExtension($receiver);
    }

    public static final void translateFunction(@NotNull TranslationContext $receiver, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($receiver.bindingContext(), declaration);
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"BindingUtils.getFunction\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (declaration.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"translateFunctionBody(de\u2026iptor, declaration, this)");
            JsBlock body = jsBlock;
            JsBlock jsBlock2 = function2.getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"function.body");
            Collection collection = jsBlock2.getStatements();
            List<JsStatement> list2 = body.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
            Iterable iterable = list2;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $receiver, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi(sourceElement);
        if (descriptor2.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            JsConfig jsConfig = $receiver.getConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsConfig, (String)"config");
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = jsConfig.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor2, function2, sourceInfo);
            }
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig2 = $receiver.getConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsConfig2, (String)"config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig2)) {
                InlineMetadata metadata2 = InlineMetadata.Companion.compose(function2, descriptor2, $receiver);
                jsExpression = metadata2.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext;
                InlineFunctionContext inlineFunctionContext2 = $receiver.getInlineFunctionContext();
                if (inlineFunctionContext2 == null) {
                    Intrinsics.throwNpe();
                }
                InlineFunctionContext it = inlineFunctionContext = inlineFunctionContext2;
                List<JsStatement> list2 = it.getImportBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.importBlock.statements");
                Collection collection = list2;
                List<JsStatement> list3 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)list3);
                List<JsStatement> list4 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)list4), (Object)new JsReturn(function2)));
                jsExpression = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(@NotNull IncrementalResultsConsumer $receiver, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string;
        Object object;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        SourceFile sourceFile = sourceElement.getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((object = (PsiSourceFile)sourceFile) == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
            return;
        }
        Object psiFile = object;
        File file2 = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"VfsUtilCore.virtualToIoFile(psiFile.virtualFile)");
        File file3 = file2;
        Visibility visibility = descriptor2.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"descriptor.visibility");
        if (EffectiveVisibilityKt.effectiveVisibility(visibility, descriptor2, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor2;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            string = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else {
            String string2 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"descriptor.fqNameSafe.asString()");
        }
        String fqName2 = string;
        UserDataHolder userDataHolder = sourceInfo;
        Integer offset2 = userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? Integer.valueOf(userDataHolder.getStartOffset()) : null;
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2);
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        $receiver.processInlineFunction(file3, fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

