/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.scheduling;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.kotlin.kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.DefaultExecutor;
import org.jetbrains.kotlin.kotlinx.coroutines.Delay;
import org.jetbrains.kotlin.kotlinx.coroutines.DisposableHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.ExecutorCoroutineDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.CoroutineScheduler;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.LimitingDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TaskContext;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TaskMode;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TasksKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0016J)\u0010\u001b\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001c\u0010 \u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0016J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0016J\u0015\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020,H\u0016J\r\u0010-\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/ExperimentalCoroutineDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/ExecutorCoroutineDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Delay;", "corePoolSize", "", "maxPoolSize", "(II)V", "idleWorkerKeepAliveNs", "", "(IIJ)V", "coroutineScheduler", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler;", "executor", "Ljava/util/concurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "blocking", "Lorg/jetbrains/kotlin/kotlinx/coroutines/CoroutineDispatcher;", "parallelism", "close", "", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Runnable;", "dispatchWithContext", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/TaskContext;", "fair", "", "dispatchWithContext$kotlinx_coroutines_core", "dispatchYield", "limited", "scheduleResumeAfterDelay", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "continuation", "Lorg/jetbrains/kotlin/kotlinx/coroutines/CancellableContinuation;", "shutdown", "timeout", "shutdown$kotlinx_coroutines_core", "toString", "", "usePrivateScheduler", "usePrivateScheduler$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public class ExperimentalCoroutineDispatcher
extends ExecutorCoroutineDispatcher
implements Delay {
    private CoroutineScheduler coroutineScheduler;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long idleWorkerKeepAliveNs;

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.coroutineScheduler;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, false, 6, null);
    }

    @Override
    public void dispatchYield(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, true, 2, null);
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(time, unit, continuation);
    }

    @Override
    public void close() {
        this.coroutineScheduler.close();
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "[scheduler = " + this.coroutineScheduler + ']';
    }

    @NotNull
    public final CoroutineDispatcher blocking(int parallelism) {
        boolean bl;
        boolean bl2 = bl = parallelism > 0;
        if (!bl) {
            String string = "Expected positive parallelism level, but have " + parallelism;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LimitingDispatcher(this, parallelism, TaskMode.PROBABLY_BLOCKING);
    }

    @NotNull
    public static /* synthetic */ CoroutineDispatcher blocking$default(ExperimentalCoroutineDispatcher experimentalCoroutineDispatcher, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: blocking");
        }
        if ((n2 & 1) != 0) {
            n = TasksKt.BLOCKING_DEFAULT_PARALLELISM;
        }
        return experimentalCoroutineDispatcher.blocking(n);
    }

    @NotNull
    public final CoroutineDispatcher limited(int parallelism) {
        boolean bl;
        boolean bl2 = bl = parallelism > 0;
        if (!bl) {
            String string = "Expected positive parallelism level, but have " + parallelism;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = parallelism <= this.corePoolSize;
        if (!bl) {
            String string = "Expected parallelism level lesser than core pool size (" + this.corePoolSize + "), but have " + parallelism;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LimitingDispatcher(this, parallelism, TaskMode.NON_BLOCKING);
    }

    public final void dispatchWithContext$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext context, boolean fair) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.coroutineScheduler.dispatch(block, context, fair);
    }

    public final void usePrivateScheduler$kotlinx_coroutines_core() {
        this.coroutineScheduler.shutdown(1000L);
        this.coroutineScheduler = new CoroutineScheduler(this.corePoolSize, this.maxPoolSize, this.idleWorkerKeepAliveNs, null, 8, null);
    }

    public final void shutdown$kotlinx_coroutines_core(long timeout) {
        this.coroutineScheduler.shutdown(timeout);
    }

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.coroutineScheduler = new CoroutineScheduler(this.corePoolSize, this.maxPoolSize, this.idleWorkerKeepAliveNs, null, 8, null);
    }

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize) {
        this(corePoolSize, maxPoolSize, TasksKt.IDLE_WORKER_KEEP_ALIVE_NS);
    }

    public /* synthetic */ ExperimentalCoroutineDispatcher(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = TasksKt.CORE_POOL_SIZE;
        }
        if ((n3 & 2) != 0) {
            n2 = TasksKt.MAX_POOL_SIZE;
        }
        this(n, n2);
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation) {
        return Delay.DefaultImpls.delay(this, time, unit, continuation);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return Delay.DefaultImpls.invokeOnTimeout(this, time, unit, block);
    }
}

