/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;

public class DefaultBasePluginConvention
extends BasePluginConvention
implements HasPublicType {
    private ProjectInternal project;
    private String distsDirName;
    private String libsDirName;
    private File buildDir;
    private File libsDir;
    private File distsDir;
    private String archivesBaseName;

    public DefaultBasePluginConvention(Project project) {
        this.project = (ProjectInternal)project;
        this.archivesBaseName = project.getName();
        this.distsDirName = "distributions";
        this.libsDirName = "libs";
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(BasePluginConvention.class);
    }

    @Override
    public File getDistsDir() {
        File dir;
        File curProjectBuildDir = this.project.getBuildDir();
        if (this.distsDir != null && curProjectBuildDir.equals(this.buildDir)) {
            return this.distsDir;
        }
        this.buildDir = curProjectBuildDir;
        this.distsDir = dir = ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(curProjectBuildDir).resolve((Object)this.distsDirName);
        return dir;
    }

    @Override
    public File getLibsDir() {
        File dir;
        File curProjectBuildDir = this.project.getBuildDir();
        if (this.libsDir != null && curProjectBuildDir.equals(this.buildDir)) {
            return this.libsDir;
        }
        this.buildDir = curProjectBuildDir;
        this.libsDir = dir = ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(curProjectBuildDir).resolve((Object)this.libsDirName);
        return dir;
    }

    @Override
    public ProjectInternal getProject() {
        return this.project;
    }

    @Override
    public void setProject(ProjectInternal project) {
        this.project = project;
    }

    @Override
    public String getDistsDirName() {
        return this.distsDirName;
    }

    @Override
    public void setDistsDirName(String distsDirName) {
        this.distsDirName = distsDirName;
        this.distsDir = null;
    }

    @Override
    public String getLibsDirName() {
        return this.libsDirName;
    }

    @Override
    public void setLibsDirName(String libsDirName) {
        this.libsDirName = libsDirName;
        this.libsDir = null;
    }

    @Override
    public String getArchivesBaseName() {
        return this.archivesBaseName;
    }

    @Override
    public void setArchivesBaseName(String archivesBaseName) {
        this.archivesBaseName = archivesBaseName;
    }
}

