/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.nativeplatform.internal.DefaultLinkerSpec;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.SharedLibraryLinkerSpec;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class LinkSharedLibrary
extends AbstractLinkTask {
    private String installName;
    private final RegularFileProperty importLibrary = this.getProject().getObjects().fileProperty();

    public LinkSharedLibrary() {
        this.importLibrary.set(this.getProject().getLayout().getProjectDirectory().file(this.getProject().getProviders().provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                RegularFile binaryFile = (RegularFile)LinkSharedLibrary.this.getLinkedFile().getOrNull();
                if (binaryFile == null) {
                    return null;
                }
                NativeToolChainInternal toolChain = (NativeToolChainInternal)LinkSharedLibrary.this.getToolChain().getOrNull();
                NativePlatformInternal targetPlatform = (NativePlatformInternal)LinkSharedLibrary.this.getTargetPlatform().getOrNull();
                if (toolChain == null || targetPlatform == null) {
                    return null;
                }
                PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
                if (!toolProvider.producesImportLibrary()) {
                    return null;
                }
                return toolProvider.getImportLibraryName(binaryFile.getAsFile().getAbsolutePath());
            }
        })));
    }

    @Optional
    @OutputFile
    public RegularFileProperty getImportLibrary() {
        return this.importLibrary;
    }

    @Nullable
    @Optional
    @Input
    public String getInstallName() {
        return this.installName;
    }

    public void setInstallName(@Nullable String installName) {
        this.installName = installName;
    }

    @Override
    protected LinkerSpec createLinkerSpec() {
        Spec spec = new Spec();
        spec.setInstallName(this.getInstallName());
        spec.setImportLibrary((File)this.importLibrary.getAsFile().getOrNull());
        return spec;
    }

    private static class Spec
    extends DefaultLinkerSpec
    implements SharedLibraryLinkerSpec {
        private String installName;
        private File importLibrary;

        private Spec() {
        }

        @Override
        public String getInstallName() {
            return this.installName;
        }

        void setInstallName(String installName) {
            this.installName = installName;
        }

        @Override
        public File getImportLibrary() {
            return this.importLibrary;
        }

        void setImportLibrary(File importLibrary) {
            this.importLibrary = importLibrary;
        }
    }
}

