/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.changes.TaskStateChangeVisitor;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.FingerprintMapSerializer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class DefaultHistoricalFileCollectionFingerprint
implements HistoricalFileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final FingerprintCompareStrategy compareStrategy;
    private final ImmutableMultimap<String, HashCode> rootHashes;

    public DefaultHistoricalFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> fingerprints, FingerprintCompareStrategy compareStrategy, ImmutableMultimap<String, HashCode> rootHashes) {
        this.fingerprints = fingerprints;
        this.compareStrategy = compareStrategy;
        this.rootHashes = rootHashes;
    }

    @Override
    public boolean visitChangesSince(FileCollectionFingerprint oldFingerprint, String title, boolean includeAdded, TaskStateChangeVisitor visitor) {
        return this.compareStrategy.visitChangesSince(visitor, this.getFingerprints(), oldFingerprint.getFingerprints(), title, includeAdded);
    }

    @VisibleForTesting
    FingerprintCompareStrategy getCompareStrategy() {
        return this.compareStrategy;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public HistoricalFileCollectionFingerprint archive() {
        return this;
    }

    public static class SerializerImpl
    implements Serializer<DefaultHistoricalFileCollectionFingerprint> {
        private final FingerprintMapSerializer fingerprintMapSerializer;
        private final StringInterner stringInterner;
        private final HashCodeSerializer hashCodeSerializer;
        private final BiMap<Integer, FingerprintCompareStrategy> compareStrategies;

        public SerializerImpl(StringInterner stringInterner, List<FingerprintCompareStrategy> compareStrategies) {
            this.fingerprintMapSerializer = new FingerprintMapSerializer(stringInterner);
            this.stringInterner = stringInterner;
            this.hashCodeSerializer = new HashCodeSerializer();
            this.compareStrategies = SerializerImpl.mapStrategies(compareStrategies);
        }

        private static BiMap<Integer, FingerprintCompareStrategy> mapStrategies(List<FingerprintCompareStrategy> compareStrategies) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            ListIterator<FingerprintCompareStrategy> iStrategy = compareStrategies.listIterator();
            while (iStrategy.hasNext()) {
                int index = iStrategy.nextIndex();
                FingerprintCompareStrategy strategy = iStrategy.next();
                builder.put((Object)index, (Object)strategy);
            }
            return builder.build();
        }

        public DefaultHistoricalFileCollectionFingerprint read(Decoder decoder) throws IOException {
            int type = decoder.readSmallInt();
            FingerprintCompareStrategy compareStrategy = (FingerprintCompareStrategy)this.compareStrategies.get((Object)type);
            Object fingerprints = this.fingerprintMapSerializer.read(decoder);
            ImmutableMultimap<String, HashCode> rootHashes = this.readRootHashes(decoder);
            return new DefaultHistoricalFileCollectionFingerprint((Map<String, FileSystemLocationFingerprint>)fingerprints, compareStrategy, rootHashes);
        }

        private ImmutableMultimap<String, HashCode> readRootHashes(Decoder decoder) throws IOException {
            int numberOfRoots = decoder.readSmallInt();
            if (numberOfRoots == 0) {
                return ImmutableMultimap.of();
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i = 0; i < numberOfRoots; ++i) {
                String absolutePath = this.stringInterner.intern(decoder.readString());
                HashCode rootHash = this.hashCodeSerializer.read(decoder);
                builder.put((Object)absolutePath, (Object)rootHash);
            }
            return builder.build();
        }

        public void write(Encoder encoder, DefaultHistoricalFileCollectionFingerprint value) throws Exception {
            encoder.writeSmallInt(((Integer)this.compareStrategies.inverse().get((Object)value.compareStrategy)).intValue());
            this.fingerprintMapSerializer.write(encoder, value.getFingerprints());
            this.writeRootHashes(encoder, value.getRootHashes());
        }

        private void writeRootHashes(Encoder encoder, ImmutableMultimap<String, HashCode> rootHashes) throws IOException {
            encoder.writeSmallInt(rootHashes.size());
            for (Map.Entry entry : rootHashes.entries()) {
                encoder.writeString((CharSequence)entry.getKey());
                this.hashCodeSerializer.write(encoder, (HashCode)entry.getValue());
            }
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SerializerImpl rhs = (SerializerImpl)obj;
            return Objects.equal((Object)((Object)this.fingerprintMapSerializer), (Object)((Object)rhs.fingerprintMapSerializer)) && Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.fingerprintMapSerializer, this.hashCodeSerializer});
        }
    }
}

