/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.PolymorphicDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.internal.TypedDomainObjectContainerWrapper;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public abstract class AbstractPolymorphicDomainObjectContainer<T>
extends AbstractNamedDomainObjectContainer<T>
implements PolymorphicDomainObjectContainerInternal<T> {
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();

    protected AbstractPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    protected abstract <U extends T> U doCreate(String var1, Class<U> var2);

    @Override
    public <U extends T> U create(String name, Class<U> type) {
        this.assertMutable("create(String, Class)");
        return this.create(name, type, null);
    }

    public <U extends T> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Object item = this.findByName(name);
        if (item != null) {
            return (U)Transformers.cast(type).transform(item);
        }
        return this.create(name, type);
    }

    public <U extends T> U create(String name, Class<U> type, Action<? super U> configuration) {
        this.assertMutable("create(String, Class, Action)");
        this.assertCanAdd(name);
        U object = this.doCreate(name, type);
        this.add(object);
        if (configuration != null) {
            configuration.execute(object);
        }
        return object;
    }

    @Override
    public <U extends T> NamedDomainObjectProvider<U> register(String name, Class<U> type) throws InvalidUserDataException {
        this.assertMutable("register(String, Class)");
        return this.createDomainObjectProvider(name, type, null);
    }

    public <U extends T> NamedDomainObjectProvider<U> register(String name, Class<U> type, Action<? super U> configurationAction) throws InvalidUserDataException {
        this.assertMutable("register(String, Class, Action)");
        return this.createDomainObjectProvider(name, type, configurationAction);
    }

    protected <U extends T> NamedDomainObjectProvider<U> createDomainObjectProvider(String name, Class<U> type, @Nullable Action<? super U> configurationAction) {
        this.assertCanAdd(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, type, configurationAction}));
        this.addLater(provider);
        return provider;
    }

    @Override
    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    @Override
    protected ConfigureDelegate createConfigureDelegate(Closure configureClosure) {
        return new PolymorphicDomainObjectContainerConfigureDelegate(configureClosure, this);
    }

    public <U extends T> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        return (NamedDomainObjectContainer)this.getInstantiator().newInstance(TypedDomainObjectContainerWrapper.class, new Object[]{type, this});
    }

    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        public String getDisplayName() {
            return AbstractPolymorphicDomainObjectContainer.this.getDisplayName();
        }

        public boolean hasProperty(String name) {
            return AbstractPolymorphicDomainObjectContainer.this.findByName(name) != null;
        }

        public DynamicInvokeResult tryGetProperty(String name) {
            Object object = AbstractPolymorphicDomainObjectContainer.this.findByName(name);
            return object == null ? DynamicInvokeResult.notFound() : DynamicInvokeResult.found(object);
        }

        public Map<String, T> getProperties() {
            return AbstractPolymorphicDomainObjectContainer.this.getAsMap();
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.isConfigureMethod(name, arguments)) {
                Object element = AbstractPolymorphicDomainObjectContainer.this.getByName(name);
                Object lastArgument = arguments[arguments.length - 1];
                if (lastArgument instanceof Closure) {
                    ConfigureUtil.configure((Closure)((Closure)lastArgument), element);
                }
                return DynamicInvokeResult.found(element);
            }
            return DynamicInvokeResult.notFound();
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return (arguments.length == 1 && arguments[0] instanceof Closure || arguments.length == 1 && arguments[0] instanceof Class || arguments.length == 2 && arguments[0] instanceof Class && arguments[1] instanceof Closure) && this.hasProperty(name);
        }
    }

    public class NamedDomainObjectCreatingProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I> {
        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction) {
            super(AbstractPolymorphicDomainObjectContainer.this, name, type, configureAction);
        }

        @Override
        protected I createDomainObject() {
            return (I)AbstractPolymorphicDomainObjectContainer.this.doCreate(this.getName(), this.getType());
        }
    }
}

