/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.changes.TaskStateChange;
import org.gradle.internal.changes.TaskStateChangeVisitor;

@NonNullApi
public class PreviousSuccessTaskStateChanges
implements TaskStateChanges {
    private static final TaskStateChange PREVIOUS_FAILURE = new DescriptiveChange("Task has failed previously.", new Object[0]);
    private final TaskExecution previousExecution;

    public PreviousSuccessTaskStateChanges(TaskExecution previousExecution) {
        this.previousExecution = previousExecution;
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor) {
        if (!this.previousExecution.isSuccessful()) {
            return visitor.visitChange(PREVIOUS_FAILURE);
        }
        return true;
    }
}

