/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.changes.TaskStateChange;
import org.gradle.internal.changes.TaskStateChangeVisitor;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

class TaskTypeTaskStateChanges
implements TaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;

    public TaskTypeTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor) {
        ImplementationSnapshot prevImplementation = this.previousExecution.getTaskImplementation();
        ImplementationSnapshot taskImplementation = this.currentExecution.getTaskImplementation();
        if (!taskImplementation.getTypeName().equals(prevImplementation.getTypeName())) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.task.getIdentityPath(), prevImplementation.getTypeName(), taskImplementation.getTypeName()));
        }
        if (taskImplementation.isUnknown()) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("Task '%s' %s", this.task.getIdentityPath(), taskImplementation.getUnknownReason()));
        }
        if (prevImplementation.isUnknown()) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("During the previous execution of the task '%s', it %s", this.task.getIdentityPath(), prevImplementation.getUnknownReason()));
        }
        if (!taskImplementation.getClassLoaderHash().equals((Object)prevImplementation.getClassLoaderHash())) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.task.getIdentityPath(), prevImplementation.getClassLoaderHash(), taskImplementation.getClassLoaderHash()));
        }
        ImmutableList<ImplementationSnapshot> taskActionImplementations = this.currentExecution.getTaskActionImplementations();
        ImplementationSnapshot unknownImplementation = TaskTypeTaskStateChanges.findUnknownImplementation(taskActionImplementations);
        if (unknownImplementation != null) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("Task '%s' has an additional action that %s", this.task.getIdentityPath(), unknownImplementation.getUnknownReason()));
        }
        ImplementationSnapshot previousUnknownImplementation = TaskTypeTaskStateChanges.findUnknownImplementation(this.previousExecution.getTaskActionImplementations());
        if (previousUnknownImplementation != null) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("During the previous execution of the task '%s', it had an additional action that %s", this.task.getIdentityPath(), previousUnknownImplementation.getUnknownReason()));
        }
        if (!taskActionImplementations.equals(this.previousExecution.getTaskActionImplementations())) {
            return visitor.visitChange((TaskStateChange)new DescriptiveChange("Task '%s' has additional actions that have changed", this.task.getIdentityPath()));
        }
        return true;
    }

    @Nullable
    private static ImplementationSnapshot findUnknownImplementation(Iterable<ImplementationSnapshot> implementations) {
        for (ImplementationSnapshot implementation : implementations) {
            if (!implementation.isUnknown()) continue;
            return implementation;
        }
        return null;
    }
}

