/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.CurrentTaskExecution;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryCache;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.EmptyHistoricalFileCollectionFingerprint;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheBackedTaskHistoryRepository.class);
    private final TaskHistoryCache taskHistoryCache;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;

    public CacheBackedTaskHistoryRepository(TaskHistoryCache taskHistoryCache, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        this.taskHistoryCache = taskHistoryCache;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.fingerprinterRegistry = fingerprinterRegistry;
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task, final TaskProperties taskProperties) {
        return new TaskHistoryRepository.History(){
            private boolean previousExecutionLoadAttempted;
            private HistoricalTaskExecution previousExecution;
            private CurrentTaskExecution currentExecution;

            @Override
            public HistoricalTaskExecution getPreviousExecution() {
                if (!this.previousExecutionLoadAttempted) {
                    this.previousExecutionLoadAttempted = true;
                    this.previousExecution = CacheBackedTaskHistoryRepository.this.loadPreviousExecution(task);
                }
                return this.previousExecution;
            }

            @Override
            public CurrentTaskExecution getCurrentExecution() {
                if (this.currentExecution == null) {
                    this.currentExecution = CacheBackedTaskHistoryRepository.this.createExecution(task, taskProperties, this.getPreviousExecution());
                }
                return this.currentExecution;
            }

            @Override
            public void updateCurrentExecution() {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getPreviousExecution(), this.getCurrentExecution(), task, taskProperties);
            }

            @Override
            public void updateCurrentExecutionWithOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputSnapshot) {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getCurrentExecution(), task, (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)newOutputSnapshot);
            }

            @Override
            public void persist() {
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), this.getCurrentExecution().archive());
            }
        };
    }

    private CurrentTaskExecution createExecution(TaskInternal task, TaskProperties taskProperties, @Nullable HistoricalTaskExecution previousExecution) {
        Class<?> taskClass = task.getClass();
        List<ContextAwareTaskAction> taskActions = task.getTaskActions();
        ImplementationSnapshot taskImplementation = ImplementationSnapshot.of(taskClass, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
        ImmutableList<ImplementationSnapshot> taskActionImplementations = CacheBackedTaskHistoryRepository.collectActionImplementations(taskActions, this.classLoaderHierarchyHasher);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)task, (Object)taskImplementation);
            LOGGER.debug("Action implementations for {}: {}", (Object)task, taskActionImplementations);
        }
        ImmutableSortedMap<String, ValueSnapshot> previousInputProperties = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getInputProperties();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CacheBackedTaskHistoryRepository.snapshotTaskInputProperties(task, taskProperties, previousInputProperties, this.valueSnapshotter);
        ImmutableSortedSet<String> outputPropertyNames = CacheBackedTaskHistoryRepository.getOutputPropertyNamesForCacheKey(taskProperties);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Input", taskProperties.getInputFileProperties(), this.fingerprinterRegistry);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFiles = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Output", taskProperties.getOutputFileProperties(), this.fingerprinterRegistry);
        OverlappingOutputs overlappingOutputs = CacheBackedTaskHistoryRepository.detectOverlappingOutputs(outputFiles, previousExecution);
        return new CurrentTaskExecution(taskImplementation, taskActionImplementations, inputProperties, outputPropertyNames, inputFiles, outputFiles, overlappingOutputs);
    }

    private void updateExecution(final @Nullable HistoricalTaskExecution previousExecution, CurrentTaskExecution currentExecution, TaskInternal task, TaskProperties taskProperties) {
        final ImmutableSortedMap outputFilesAfter = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Output", taskProperties.getOutputFileProperties(), this.fingerprinterRegistry);
        ImmutableSortedMap newOutputFingerprint = currentExecution.getDetectedOverlappingOutputs() == null ? outputFilesAfter : ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(currentExecution.getOutputFingerprints(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, CurrentFileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            public CurrentFileCollectionFingerprint transformEntry(String propertyName, CurrentFileCollectionFingerprint beforeExecution) {
                CurrentFileCollectionFingerprint afterExecution = (CurrentFileCollectionFingerprint)outputFilesAfter.get((Object)propertyName);
                HistoricalFileCollectionFingerprint afterPreviousExecution = CacheBackedTaskHistoryRepository.getFingerprintAfterPreviousExecution(previousExecution, propertyName);
                return CacheBackedTaskHistoryRepository.filterOutputFingerprint(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.updateExecution(currentExecution, task, newOutputFingerprint);
    }

    private void updateExecution(CurrentTaskExecution currentExecution, TaskInternal task, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprint) {
        currentExecution.setSuccessful(task.getState().getFailure() == null);
        currentExecution.setOutputFingerprintsAfterExecution(newOutputFingerprint);
    }

    private static CurrentFileCollectionFingerprint filterOutputFingerprint(@Nullable HistoricalFileCollectionFingerprint afterPreviousExecution, CurrentFileCollectionFingerprint beforeExecution, CurrentFileCollectionFingerprint afterExecution) {
        CurrentFileCollectionFingerprint filesFingerprint;
        final Map<String, FileSystemLocationSnapshot> beforeExecutionSnapshots = CacheBackedTaskHistoryRepository.getAllSnapshots(beforeExecution);
        if (!beforeExecution.getFingerprints().isEmpty() && !afterExecution.getFingerprints().isEmpty()) {
            Object afterPreviousFingerprints = afterPreviousExecution != null ? afterPreviousExecution.getFingerprints() : ImmutableMap.of();
            ArrayList newRoots = new ArrayList();
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            afterExecution.accept(new FileSystemSnapshotVisitor((Map)afterPreviousFingerprints, hasBeenFiltered, newRoots){
                private MerkleDirectorySnapshotBuilder merkleBuilder;
                private boolean currentRootFiltered = false;
                private DirectorySnapshot currentRoot;
                final /* synthetic */ Map val$afterPreviousFingerprints;
                final /* synthetic */ MutableBoolean val$hasBeenFiltered;
                final /* synthetic */ List val$newRoots;
                {
                    this.val$afterPreviousFingerprints = map2;
                    this.val$hasBeenFiltered = mutableBoolean;
                    this.val$newRoots = list;
                }

                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    if (this.merkleBuilder == null) {
                        this.merkleBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                        this.currentRoot = directorySnapshot;
                        this.currentRootFiltered = false;
                    }
                    this.merkleBuilder.preVisitDirectory(directorySnapshot);
                    return true;
                }

                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    if (!CacheBackedTaskHistoryRepository.isOutputEntry(fileSnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints)) {
                        this.val$hasBeenFiltered.set(true);
                        this.currentRootFiltered = true;
                        return;
                    }
                    if (this.merkleBuilder == null) {
                        this.val$newRoots.add(fileSnapshot);
                    } else {
                        this.merkleBuilder.visit(fileSnapshot);
                    }
                }

                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                    boolean isOutputDir = CacheBackedTaskHistoryRepository.isOutputEntry((FileSystemLocationSnapshot)directorySnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints);
                    boolean includedDir = this.merkleBuilder.postVisitDirectory(isOutputDir);
                    if (!includedDir) {
                        this.currentRootFiltered = true;
                        this.val$hasBeenFiltered.set(true);
                    }
                    if (this.merkleBuilder.isRoot()) {
                        FileSystemLocationSnapshot result = this.merkleBuilder.getResult();
                        if (result != null) {
                            this.val$newRoots.add(this.currentRootFiltered ? result : this.currentRoot);
                        }
                        this.merkleBuilder = null;
                        this.currentRoot = null;
                    }
                }
            });
            filesFingerprint = !hasBeenFiltered.get() ? afterExecution : DefaultCurrentFileCollectionFingerprint.from(newRoots, (FingerprintingStrategy)AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        } else {
            filesFingerprint = afterExecution;
        }
        return filesFingerprint;
    }

    private static Map<String, FileSystemLocationSnapshot> getAllSnapshots(CurrentFileCollectionFingerprint fingerprint) {
        GetAllSnapshotsVisitor afterExecutionVisitor = new GetAllSnapshotsVisitor();
        fingerprint.accept((FileSystemSnapshotVisitor)afterExecutionVisitor);
        return afterExecutionVisitor.getSnapshots();
    }

    private static boolean isOutputEntry(FileSystemLocationSnapshot snapshot, Map<String, FileSystemLocationSnapshot> beforeSnapshots, Map<String, FileSystemLocationFingerprint> afterPreviousFingerprints) {
        if (snapshot.getType() == FileType.Missing) {
            return false;
        }
        FileSystemLocationSnapshot beforeSnapshot = beforeSnapshots.get(snapshot.getAbsolutePath());
        if (beforeSnapshot == null) {
            return true;
        }
        if (!snapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return afterPreviousFingerprints.containsKey(snapshot.getAbsolutePath());
    }

    private static ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImplementations = ImmutableList.builder();
        for (ContextAwareTaskAction taskAction : taskActions) {
            actionImplementations.add((Object)taskAction.getActionImplementation(classLoaderHierarchyHasher));
        }
        return actionImplementations.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotTaskInputProperties(TaskInternal task, TaskProperties taskProperties, ImmutableSortedMap<String, ValueSnapshot> previousInputProperties, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        Map inputPropertyValues = (Map)taskProperties.getInputPropertyValues().create();
        assert (inputPropertyValues != null);
        for (Map.Entry entry : inputPropertyValues.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                    continue;
                }
                builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", task, propertyName, value), (Throwable)e);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintTaskFiles(TaskInternal task, String title, SortedSet<? extends TaskFilePropertySpec> fileProperties, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionFingerprinter fingerprinter = fingerprinterRegistry.getFingerprinter(taskFilePropertySpec.getNormalizer());
            LOGGER.debug("Fingerprinting property {} for {}", (Object)taskFilePropertySpec, (Object)task);
            CurrentFileCollectionFingerprint result = fingerprinter.fingerprint(taskFilePropertySpec.getPropertyFiles());
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    @Nullable
    private static OverlappingOutputs detectOverlappingOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> taskOutputs, @Nullable HistoricalTaskExecution previousExecution) {
        for (Map.Entry entry : taskOutputs.entrySet()) {
            String propertyName = (String)entry.getKey();
            FileCollectionFingerprint beforeExecution = (FileCollectionFingerprint)entry.getValue();
            HistoricalFileCollectionFingerprint afterPreviousExecution = CacheBackedTaskHistoryRepository.getFingerprintAfterPreviousExecution(previousExecution, propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    private static HistoricalFileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable HistoricalTaskExecution previousExecution, String propertyName) {
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> previousFingerprints;
        HistoricalFileCollectionFingerprint afterPreviousExecution;
        if (previousExecution != null && (afterPreviousExecution = (HistoricalFileCollectionFingerprint)(previousFingerprints = previousExecution.getOutputFingerprints()).get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return EmptyHistoricalFileCollectionFingerprint.INSTANCE;
    }

    @Nullable
    private HistoricalTaskExecution loadPreviousExecution(TaskInternal task) {
        return this.taskHistoryCache.get(task.getPath());
    }

    private static ImmutableSortedSet<String> getOutputPropertyNamesForCacheKey(TaskProperties taskProperties) {
        ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties = taskProperties.getOutputFileProperties();
        ArrayList outputPropertyNames = Lists.newArrayListWithCapacity((int)fileProperties.size());
        for (TaskOutputFilePropertySpec propertySpec : fileProperties) {
            CacheableTaskOutputFilePropertySpec cacheablePropertySpec;
            if (!(propertySpec instanceof CacheableTaskOutputFilePropertySpec) || (cacheablePropertySpec = (CacheableTaskOutputFilePropertySpec)propertySpec).getOutputFile() == null) continue;
            outputPropertyNames.add(propertySpec.getPropertyName());
        }
        return ImmutableSortedSet.copyOf((Collection)outputPropertyNames);
    }

    private static class GetAllSnapshotsVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();

        private GetAllSnapshotsVisitor() {
        }

        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.snapshots.put(directorySnapshot.getAbsolutePath(), (FileSystemLocationSnapshot)directorySnapshot);
            return true;
        }

        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            this.snapshots.put(fileSnapshot.getAbsolutePath(), fileSnapshot);
        }

        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
        }

        public Map<String, FileSystemLocationSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

