/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.FilePropertyContainer;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.DeclaredTaskInputProperty;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskInputPropertySpec;
import org.gradle.api.internal.tasks.TaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.GetInputFilesVisitor;
import org.gradle.api.internal.tasks.properties.GetInputPropertiesVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.TaskInputPropertyBuilder;
import org.gradle.api.tasks.TaskInputs;

@NonNullApi
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final PropertyWalker propertyWalker;
    private final List<DeclaredTaskInputProperty> registeredProperties = Lists.newArrayList();
    private final FilePropertyContainer<DeclaredTaskInputFileProperty> registeredFileProperties = FilePropertyContainer.create();
    private final TaskInputs deprecatedThis;
    private final PropertySpecFactory specFactory;

    public DefaultTaskInputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, PropertySpecFactory specFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.propertyWalker = propertyWalker;
        String taskDisplayName = task.toString();
        this.allInputFiles = new TaskInputUnionFileCollection(taskDisplayName, "input", false, task, propertyWalker);
        this.allSourceFiles = new TaskInputUnionFileCollection(taskDisplayName, "source", true, task, propertyWalker);
        this.deprecatedThis = new TaskInputsDeprecationSupport();
        this.specFactory = specFactory;
    }

    public boolean getHasInputs() {
        HasInputsVisitor visitor = new HasInputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasInputs();
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (DeclaredTaskInputFileProperty fileProperty : this.registeredFileProperties) {
            visitor.visitInputFileProperty(fileProperty);
        }
        for (DeclaredTaskInputProperty inputProperty : this.registeredProperties) {
            visitor.visitInputProperty(inputProperty);
        }
    }

    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    public TaskInputFilePropertyBuilderInternal files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(DefaultTaskInputs.unpackVarargs(paths));
                DeclaredTaskInputFileProperty fileSpec = DefaultTaskInputs.this.specFactory.createInputFilesSpec(value);
                DefaultTaskInputs.this.registeredFileProperties.add(fileSpec);
                return fileSpec;
            }
        });
    }

    private static Object unpackVarargs(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return args;
    }

    public TaskInputFilePropertyBuilderInternal file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(path);
                DeclaredTaskInputFileProperty fileSpec = DefaultTaskInputs.this.specFactory.createInputFileSpec(value);
                DefaultTaskInputs.this.registeredFileProperties.add(fileSpec);
                return fileSpec;
            }
        });
    }

    public TaskInputFilePropertyBuilderInternal dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(dirPath);
                DeclaredTaskInputFileProperty dirSpec = DefaultTaskInputs.this.specFactory.createInputDirSpec(value);
                DefaultTaskInputs.this.registeredFileProperties.add(dirSpec);
                return dirSpec;
            }
        });
    }

    public boolean getHasSourceFiles() {
        GetInputFilesVisitor visitor = new GetInputFilesVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasSourceFiles();
    }

    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    public Map<String, Object> getProperties() {
        GetInputPropertiesVisitor visitor = new GetInputPropertiesVisitor(this.task.getName());
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return (Map)visitor.getPropertyValuesFactory().create();
    }

    public TaskInputPropertyBuilder property(final String name, final @Nullable Object value) {
        return this.taskMutator.mutate("TaskInputs.property(String, Object)", new Callable<TaskInputPropertyBuilder>(){

            @Override
            public TaskInputPropertyBuilder call() {
                StaticValue staticValue = new StaticValue(value);
                DefaultTaskInputPropertySpec inputPropertySpec = DefaultTaskInputs.this.specFactory.createInputPropertySpec(name, staticValue);
                DefaultTaskInputs.this.registeredProperties.add(inputPropertySpec);
                return inputPropertySpec;
            }
        });
    }

    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : newProps.entrySet()) {
                    StaticValue staticValue = new StaticValue(entry.getValue());
                    String name = (String)entry.getKey();
                    DefaultTaskInputs.this.registeredProperties.add(DefaultTaskInputs.this.specFactory.createInputPropertySpec(name, staticValue));
                }
            }
        });
        return this.deprecatedThis;
    }

    private static class HasInputsVisitor
    extends PropertyVisitor.Adapter {
        private boolean hasInputs;

        private HasInputsVisitor() {
        }

        public boolean hasInputs() {
            return this.hasInputs;
        }

        @Override
        public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
            this.hasInputs = true;
        }

        @Override
        public void visitInputProperty(TaskInputPropertySpec inputProperty) {
            this.hasInputs = true;
        }
    }

    private static class TaskInputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final boolean skipWhenEmptyOnly;
        private final String taskDisplayName;
        private final String type;
        private final TaskInternal task;
        private final PropertyWalker propertyWalker;

        TaskInputUnionFileCollection(String taskDisplayName, String type, boolean skipWhenEmptyOnly, TaskInternal task, PropertyWalker propertyWalker) {
            this.taskDisplayName = taskDisplayName;
            this.type = type;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
            this.task = task;
            this.propertyWalker = propertyWalker;
        }

        public String getDisplayName() {
            return this.taskDisplayName + " " + this.type + " files";
        }

        public void visitContents(final FileCollectionResolveContext context) {
            TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new PropertyVisitor.Adapter(){

                @Override
                public void visitInputFileProperty(TaskInputFilePropertySpec fileProperty) {
                    if (!TaskInputUnionFileCollection.this.skipWhenEmptyOnly || fileProperty.isSkipWhenEmpty()) {
                        context.add((Object)fileProperty.getPropertyFiles());
                    }
                }
            });
        }
    }
}

