/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationResult;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class EventFiringTaskExecuter
implements TaskExecuter {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskExecutionListener taskExecutionListener;
    private final TaskExecuter delegate;

    public EventFiringTaskExecuter(BuildOperationExecutor buildOperationExecutor, TaskExecutionListener taskExecutionListener, TaskExecuter delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.taskExecutionListener = taskExecutionListener;
        this.delegate = delegate;
    }

    @Override
    public void execute(final TaskInternal task, final TaskStateInternal state, final TaskExecutionContext context) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext operationContext) {
                EventFiringTaskExecuter.this.taskExecutionListener.beforeExecute((Task)task);
                EventFiringTaskExecuter.this.delegate.execute(task, state, context);
                operationContext.setResult((Object)new ExecuteTaskBuildOperationResult(state, context));
                EventFiringTaskExecuter.this.taskExecutionListener.afterExecute((Task)task, (TaskState)state);
                operationContext.setStatus(state.getFailure() != null ? "FAILED" : state.getSkipMessage());
                operationContext.failed(state.getFailure());
            }

            public BuildOperationDescriptor.Builder description() {
                ExecuteTaskBuildOperationDetails taskOperation = new ExecuteTaskBuildOperationDetails(task);
                return BuildOperationDescriptor.displayName((String)("Task " + task.getIdentityPath())).name(task.getIdentityPath().toString()).progressDisplayName(task.getIdentityPath().toString()).operationType(BuildOperationCategory.TASK).details((Object)taskOperation);
            }
        });
    }
}

