/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.configuration.project.NotifyProjectAfterEvaluatedBuildOperationType;
import org.gradle.configuration.project.NotifyProjectBeforeEvaluatedBuildOperationType;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleProjectEvaluator
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleProjectEvaluator.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectEvaluator delegate;

    public LifecycleProjectEvaluator(BuildOperationExecutor buildOperationExecutor, ProjectEvaluator delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    @Override
    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        if (state.isUnconfigured()) {
            this.buildOperationExecutor.run((RunnableBuildOperation)new EvaluateProject(project, state));
        }
    }

    private static void addConfigurationFailure(ProjectInternal project, ProjectStateInternal state, Exception e, BuildOperationContext ctx) {
        Exception exception = LifecycleProjectEvaluator.wrapException(project, e);
        ctx.failed((Throwable)exception);
        state.failed(exception);
    }

    private static Exception wrapException(ProjectInternal project, Exception e) {
        return new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), (Throwable)e);
    }

    private static class NotifyAfterEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyAfterEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        public void run(BuildOperationContext context) {
            ProjectEvaluationListener nextBatch = this.project.getProjectEvaluationBroadcaster();
            Action<ProjectEvaluationListener> fireAction = new Action<ProjectEvaluationListener>(){

                public void execute(ProjectEvaluationListener listener) {
                    listener.afterEvaluate((Project)NotifyAfterEvaluate.this.project, (ProjectState)NotifyAfterEvaluate.this.state);
                }
            };
            do {
                try {
                    nextBatch = this.project.stepEvaluationListener(nextBatch, fireAction);
                }
                catch (Exception e) {
                    if (this.state.hasFailure()) {
                        this.logError(e, this.project);
                        context.failed((Throwable)LifecycleProjectEvaluator.wrapException(this.project, e));
                    } else {
                        LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
                    }
                    return;
                }
            } while (nextBatch != null);
            context.setResult((Object)NotifyProjectAfterEvaluatedBuildOperationType.RESULT);
        }

        private void logError(Exception e, ProjectInternal project) {
            boolean logStackTraces = project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
            String infoMessage = "Project evaluation failed including an error in afterEvaluate {}.";
            if (logStackTraces) {
                LOGGER.error(infoMessage, (Throwable)e);
            } else {
                LOGGER.error(infoMessage + " Run with --stacktrace for details of the afterEvaluate {} error.");
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Notify afterEvaluate listeners of " + this.project.getIdentityPath())).details((Object)new NotifyProjectAfterEvaluatedBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private static class NotifyBeforeEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyBeforeEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        public void run(BuildOperationContext context) {
            try {
                this.project.getProjectEvaluationBroadcaster().beforeEvaluate((Project)this.project);
                context.setResult((Object)NotifyProjectBeforeEvaluatedBuildOperationType.RESULT);
            }
            catch (Exception e) {
                LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Notify beforeEvaluate listeners of " + this.project.getIdentityPath())).details((Object)new NotifyProjectBeforeEvaluatedBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private class EvaluateProject
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private EvaluateProject(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        public void run(final BuildOperationContext context) {
            this.project.getMutationState().withMutableState(new Runnable(){

                @Override
                public void run() {
                    try {
                        EvaluateProject.this.state.toBeforeEvaluate();
                        LifecycleProjectEvaluator.this.buildOperationExecutor.run((RunnableBuildOperation)new NotifyBeforeEvaluate(EvaluateProject.this.project, EvaluateProject.this.state));
                        if (!EvaluateProject.this.state.hasFailure()) {
                            EvaluateProject.this.state.toEvaluate();
                            try {
                                LifecycleProjectEvaluator.this.delegate.evaluate(EvaluateProject.this.project, EvaluateProject.this.state);
                            }
                            catch (Exception e) {
                                LifecycleProjectEvaluator.addConfigurationFailure(EvaluateProject.this.project, EvaluateProject.this.state, e, context);
                            }
                            finally {
                                EvaluateProject.this.state.toAfterEvaluate();
                                LifecycleProjectEvaluator.this.buildOperationExecutor.run((RunnableBuildOperation)new NotifyAfterEvaluate(EvaluateProject.this.project, EvaluateProject.this.state));
                            }
                        }
                        if (EvaluateProject.this.state.hasFailure()) {
                            EvaluateProject.this.state.rethrowFailure();
                        } else {
                            context.setResult((Object)ConfigureProjectBuildOperationType.RESULT);
                        }
                    }
                    finally {
                        EvaluateProject.this.state.configured();
                    }
                }
            });
        }

        public BuildOperationDescriptor.Builder description() {
            Path identityPath = this.project.getIdentityPath();
            String displayName = "Configure project " + identityPath.toString();
            String progressDisplayName = identityPath.toString();
            if (identityPath.equals((Object)Path.ROOT)) {
                progressDisplayName = "root project";
            }
            return BuildOperationDescriptor.displayName((String)displayName).operationType(BuildOperationCategory.CONFIGURE_PROJECT).progressDisplayName(progressDisplayName).details((Object)new ConfigureProjectBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }
}

