/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.io.File;
import java.io.FileNotFoundException;
import org.gradle.api.UncheckedIOException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.ScriptSourceHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.resource.TextResource;

public class DefaultScriptSourceHasher
implements ScriptSourceHasher {
    private static final HashCode SIGNATURE = Hashing.signature(DefaultScriptSourceHasher.class);
    private final FileHasher fileHasher;

    public DefaultScriptSourceHasher(FileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    @Override
    public HashCode hash(ScriptSource scriptSource) {
        TextResource resource = scriptSource.getResource();
        File file = resource.getFile();
        if (file != null) {
            try {
                return this.fileHasher.hash(file);
            }
            catch (UncheckedIOException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    throw new UncheckedIOException("Could not read " + scriptSource.getDisplayName() + " as it does not exist.", e.getCause());
                }
                throw e;
            }
        }
        PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
        hasher.putHash(SIGNATURE);
        hasher.putString((CharSequence)resource.getText());
        return hasher.hash();
    }
}

