/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import com.google.common.base.Objects;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.ReusableAction;
import org.gradle.internal.component.external.model.ComponentVariant;

public abstract class PlatformSupport {
    public static final Attribute<String> COMPONENT_CATEGORY = Attribute.of((String)"org.gradle.component.category", String.class);
    public static final String LIBRARY = "library";
    public static final String REGULAR_PLATFORM = "platform";
    public static final String ENFORCED_PLATFORM = "enforced-platform";

    public static boolean isTargettingPlatform(HasConfigurableAttributes<?> target) {
        String category = (String)target.getAttributes().getAttribute(COMPONENT_CATEGORY);
        return REGULAR_PLATFORM.equals(category) || ENFORCED_PLATFORM.equals(category);
    }

    public static void configureSchema(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy componentTypeMatchingStrategy = attributesSchema.attribute(COMPONENT_CATEGORY);
        componentTypeMatchingStrategy.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class);
    }

    static <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, final String type) {
        dependency.attributes((Action)new Action<AttributeContainer>(){

            public void execute(AttributeContainer attributeContainer) {
                attributeContainer.attribute(COMPONENT_CATEGORY, (Object)type);
            }
        });
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal((Object)variant.getAttributes().getAttribute(COMPONENT_CATEGORY), (Object)ENFORCED_PLATFORM);
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<String>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<String> details) {
            String consumerValue = (String)details.getConsumerValue();
            Set candidateValues = details.getCandidateValues();
            if (consumerValue == null && candidateValues.contains(PlatformSupport.LIBRARY)) {
                details.closestMatch((Object)PlatformSupport.LIBRARY);
                return;
            }
        }
    }
}

