/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jacoco;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.HashMap;
import java.util.Hashtable;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.internal.jacoco.AbstractAntJacocoReport;
import org.gradle.internal.jacoco.JacocoCheckResult;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.testing.jacoco.tasks.rules.JacocoLimit;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRule;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRulesContainer;

public class AntJacocoCheck
extends AbstractAntJacocoReport<JacocoViolationRulesContainer> {
    private static final String VIOLATIONS_ANT_PROPERTY = "jacocoViolations";
    private static final Predicate<JacocoViolationRule> RULE_ENABLED_PREDICATE = new Predicate<JacocoViolationRule>(){

        public boolean apply(JacocoViolationRule rule) {
            return rule.isEnabled();
        }
    };

    public AntJacocoCheck(IsolatedAntBuilder ant) {
        super(ant);
    }

    public JacocoCheckResult execute(FileCollection classpath, final String projectName, final FileCollection allClassesDirs, final FileCollection allSourcesDirs, final FileCollection executionData, final JacocoViolationRulesContainer violationRules) {
        final JacocoCheckResult jacocoCheckResult = new JacocoCheckResult();
        this.configureAntReportTask(classpath, new Action<GroovyObjectSupport>(){

            public void execute(GroovyObjectSupport antBuilder) {
                try {
                    AntJacocoCheck.this.invokeJacocoReport(antBuilder, projectName, allClassesDirs, allSourcesDirs, executionData, violationRules);
                }
                catch (Exception e) {
                    String violations = AntJacocoCheck.this.getViolations(antBuilder);
                    jacocoCheckResult.setSuccess(false);
                    jacocoCheckResult.setFailureMessage(violations != null ? violations : e.getMessage());
                }
            }
        });
        return jacocoCheckResult;
    }

    @Override
    protected void configureReport(final GroovyObjectSupport antBuilder, final JacocoViolationRulesContainer violationRules) {
        if (!violationRules.getRules().isEmpty()) {
            ImmutableMap checkArgs = ImmutableMap.of((Object)"failonviolation", (Object)violationRules.isFailOnViolation(), (Object)"violationsproperty", (Object)VIOLATIONS_ANT_PROPERTY);
            antBuilder.invokeMethod("check", (Object)new Object[]{checkArgs, new Closure<Object>((Object)this, (Object)this){

                public Object doCall(Object ignore) {
                    for (final JacocoViolationRule rule : Iterables.filter(violationRules.getRules(), (Predicate)RULE_ENABLED_PREDICATE)) {
                        ImmutableMap ruleArgs = ImmutableMap.of((Object)"element", (Object)rule.getElement(), (Object)"includes", (Object)Joiner.on((char)':').join(rule.getIncludes()), (Object)"excludes", (Object)Joiner.on((char)':').join(rule.getExcludes()));
                        antBuilder.invokeMethod("rule", (Object)new Object[]{ruleArgs, new Closure<Object>((Object)this, (Object)this){

                            public Object doCall(Object ignore) {
                                for (JacocoLimit limit : rule.getLimits()) {
                                    HashMap<String, Object> limitArgs = new HashMap<String, Object>();
                                    limitArgs.put("counter", limit.getCounter());
                                    limitArgs.put("value", limit.getValue());
                                    if (limit.getMinimum() != null) {
                                        limitArgs.put("minimum", limit.getMinimum());
                                    }
                                    if (limit.getMaximum() != null) {
                                        limitArgs.put("maximum", limit.getMaximum());
                                    }
                                    antBuilder.invokeMethod("limit", (Object)new Object[]{ImmutableMap.copyOf(limitArgs)});
                                }
                                return null;
                            }
                        }});
                    }
                    return null;
                }
            }});
        }
    }

    private String getViolations(GroovyObjectSupport antBuilder) {
        Object project = antBuilder.getProperty("project");
        Hashtable properties = (Hashtable)JavaReflectionUtil.method((Object)project, Hashtable.class, (String)"getProperties", (Class[])new Class[0]).invoke(project, new Object[0]);
        return (String)properties.get(VIOLATIONS_ANT_PROPERTY);
    }
}

