/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeFactory;
import org.gradle.execution.plan.DependencyResolver;
import org.gradle.execution.plan.Node;

public class TransformationNodeDependencyResolver
implements DependencyResolver {
    private final TransformationNodeFactory transformationNodeFactory;

    public TransformationNodeDependencyResolver(TransformationNodeFactory transformationNodeFactory) {
        this.transformationNodeFactory = transformationNodeFactory;
    }

    public boolean resolve(Task task, Object node, Action<? super Node> resolveAction) {
        if (node instanceof DefaultTransformationDependency) {
            DefaultTransformationDependency transformation = (DefaultTransformationDependency)node;
            Collection<TransformationNode> transformations = this.transformationNodeFactory.getOrCreate(transformation.getArtifacts(), transformation.getTransformation(), transformation.getDependenciesResolver());
            for (TransformationNode transformationNode : transformations) {
                resolveAction.execute((Object)transformationNode);
            }
            return true;
        }
        return false;
    }

    public boolean attachActionTo(Node value, Action<? super Task> action) {
        return false;
    }
}

