/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.PackageNameBuilder;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.internal.text.TreeFormatter;

public class InitBuild
extends DefaultTask {
    private String type;
    private String dsl;
    private String testFramework;
    private String projectName;
    private String packageName;
    @Internal
    private ProjectLayoutSetupRegistry projectLayoutRegistry;

    @Input
    public String getType() {
        return Strings.isNullOrEmpty((String)this.type) ? this.detectType() : this.type;
    }

    @Incubating
    @Optional
    @Input
    public String getDsl() {
        return Strings.isNullOrEmpty((String)this.dsl) ? BuildInitDsl.GROOVY.getId() : this.dsl;
    }

    @Incubating
    @Input
    public String getProjectName() {
        return this.projectName == null ? this.getProject().getProjectDir().getName() : this.projectName;
    }

    @Incubating
    @Input
    public String getPackageName() {
        return this.packageName == null ? "" : this.packageName;
    }

    @Nullable
    @Optional
    @Input
    public String getTestFramework() {
        return this.testFramework;
    }

    public ProjectLayoutSetupRegistry getProjectLayoutRegistry() {
        if (this.projectLayoutRegistry == null) {
            this.projectLayoutRegistry = (ProjectLayoutSetupRegistry)this.getServices().get(ProjectLayoutSetupRegistry.class);
        }
        return this.projectLayoutRegistry;
    }

    @TaskAction
    public void setupProjectLayout() {
        BuildInitDsl dsl;
        UserInputHandler inputHandler = (UserInputHandler)this.getServices().get(UserInputHandler.class);
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        String type = null;
        if (Strings.isNullOrEmpty((String)this.type)) {
            BuildConverter converter = projectLayoutRegistry.getBuildConverter();
            if (converter.canApplyToCurrentDirectory() && inputHandler.askYesNoQuestion("Found a " + converter.getSourceBuildDescription() + " build. Generate a Gradle build from this?", true)) {
                type = converter.getId();
            }
            if (type == null) {
                type = (String)inputHandler.selectOption("Select type of project to generate", projectLayoutRegistry.getBuildGenerators(), (Object)projectLayoutRegistry.getDefault().getId());
            }
        } else {
            type = this.type;
        }
        BuildInitializer initDescriptor = projectLayoutRegistry.get(type);
        if (Strings.isNullOrEmpty((String)this.dsl)) {
            dsl = initDescriptor.getDefaultDsl();
            if (initDescriptor.getDsls().size() > 1) {
                dsl = (BuildInitDsl)((Object)inputHandler.selectOption("Select build script DSL", initDescriptor.getDsls(), (Object)dsl));
            }
        } else {
            dsl = BuildInitDsl.fromName(this.getDsl());
            if (!initDescriptor.getDsls().contains((Object)dsl)) {
                throw new GradleException("The requested DSL '" + (Object)((Object)dsl) + "' is not supported for '" + type + "' setup type");
            }
        }
        BuildInitTestFramework testFramework = null;
        if (Strings.isNullOrEmpty((String)this.testFramework)) {
            testFramework = initDescriptor.getDefaultTestFramework();
            if (initDescriptor.getTestFrameworks().size() > 1) {
                testFramework = (BuildInitTestFramework)((Object)inputHandler.selectOption("Select test framework", initDescriptor.getTestFrameworks(), (Object)testFramework));
            }
        } else {
            for (Object candidate : initDescriptor.getTestFrameworks()) {
                if (!this.testFramework.equals(candidate.getId())) continue;
                testFramework = candidate;
                break;
            }
            if (testFramework == null) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("The requested test framework '" + this.getTestFramework() + "' is not supported for '" + type + "' setup type. Supported frameworks");
                formatter.startChildren();
                for (BuildInitTestFramework framework : initDescriptor.getTestFrameworks()) {
                    formatter.node("'" + framework.getId() + "'");
                }
                formatter.endChildren();
                throw new GradleException(formatter.toString());
            }
        }
        String projectName = this.projectName;
        if (initDescriptor.supportsProjectName()) {
            if (Strings.isNullOrEmpty((String)projectName)) {
                projectName = inputHandler.askQuestion("Project name", this.getProjectName());
            }
        } else if (!Strings.isNullOrEmpty((String)projectName)) {
            throw new GradleException("Project name is not supported for '" + type + "' setup type.");
        }
        String packageName = this.packageName;
        if (initDescriptor.supportsPackage()) {
            if (Strings.isNullOrEmpty((String)packageName)) {
                packageName = inputHandler.askQuestion("Source package", PackageNameBuilder.toPackageName(projectName));
            }
        } else if (!Strings.isNullOrEmpty((String)packageName)) {
            throw new GradleException("Package name is not supported for '" + type + "' setup type.");
        }
        initDescriptor.generate(new InitSettings(projectName, dsl, packageName, testFramework));
    }

    @Option(option="type", description="Set the type of project to generate.")
    public void setType(String type) {
        this.type = type;
    }

    @OptionValues(value={"type"})
    public List<String> getAvailableBuildTypes() {
        return this.getProjectLayoutRegistry().getAllTypes();
    }

    @Incubating
    @Option(option="dsl", description="Set the build script DSL to be used in generated scripts.")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    @Incubating
    @OptionValues(value={"dsl"})
    public List<String> getAvailableDSLs() {
        return BuildInitDsl.listSupported();
    }

    @Option(option="test-framework", description="Set the test framework to be used.")
    public void setTestFramework(@Nullable String testFramework) {
        this.testFramework = testFramework;
    }

    @OptionValues(value={"test-framework"})
    public List<String> getAvailableTestFrameworks() {
        return BuildInitTestFramework.listSupported();
    }

    @Incubating
    @Option(option="project-name", description="Set the project name.")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Incubating
    @Option(option="package", description="Set the package for source files.")
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    void setProjectLayoutRegistry(ProjectLayoutSetupRegistry projectLayoutRegistry) {
        this.projectLayoutRegistry = projectLayoutRegistry;
    }

    private String detectType() {
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildConverter buildConverter = projectLayoutRegistry.getBuildConverter();
        if (buildConverter.canApplyToCurrentDirectory()) {
            return buildConverter.getId();
        }
        return projectLayoutRegistry.getDefault().getId();
    }
}

