/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;

public abstract class FileTimeStampInspector {
    private final File workDir;
    private final File markerFile;
    private long lastBuildTimestamp;

    protected FileTimeStampInspector(File workDir) {
        this.workDir = workDir;
        this.markerFile = new File(workDir, "last-build.bin");
    }

    public long getLastBuildTimestamp() {
        return this.lastBuildTimestamp;
    }

    protected void updateOnStartBuild() {
        this.workDir.mkdirs();
        this.lastBuildTimestamp = this.markerFile.exists() ? this.markerFile.lastModified() : 0L;
    }

    protected void updateOnFinishBuild() {
        this.markerFile.getParentFile().mkdirs();
        try {
            FileOutputStream outputStream = new FileOutputStream(this.markerFile);
            try {
                outputStream.write(0);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not update " + this.markerFile, (Throwable)e);
        }
        this.lastBuildTimestamp = this.markerFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long currentTimestamp() {
        long l;
        File file = File.createTempFile("this-build", "bin", this.workDir);
        try {
            l = file.lastModified();
            file.delete();
        }
        catch (Throwable throwable) {
            try {
                file.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not calculate current default file timestamp.", (Throwable)e);
            }
        }
        return l;
    }

    public boolean timestampCanBeUsedToDetectFileChange(String file, long timestamp) {
        return timestamp != this.lastBuildTimestamp;
    }
}

