/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classpath.ClassPath;

public class RootClassLoaderScope
extends AbstractClassLoaderScope {
    private final ClassLoader localClassLoader;
    private final CachingClassLoader cachingLocalClassLoader;
    private final ClassLoader exportClassLoader;
    private final CachingClassLoader cachingExportClassLoader;

    public RootClassLoaderScope(ClassLoader localClassLoader, ClassLoader exportClassLoader, ClassLoaderCache classLoaderCache) {
        super(new ClassLoaderScopeIdentifier(null, "root"), classLoaderCache);
        this.localClassLoader = localClassLoader;
        this.cachingLocalClassLoader = new CachingClassLoader(localClassLoader);
        this.exportClassLoader = exportClassLoader;
        this.cachingExportClassLoader = new CachingClassLoader(exportClassLoader);
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        return this.cachingLocalClassLoader;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        return this.cachingExportClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        return this.localClassLoader.equals(clazz.getClassLoader()) || this.exportClassLoader.equals(clazz.getClassLoader());
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope lock() {
        return this;
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

