/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.project.antbuilder.CacheEntry;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.Cleanup;
import org.gradle.api.internal.project.antbuilder.FinalizerThread;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;

public class ClassPathToClassLoaderCache
implements Stoppable {
    private static final Logger LOG = Logging.getLogger(ClassPathToClassLoaderCache.class);
    private final FinalizerThread finalizerThread;
    private final Lock lock = new ReentrantLock();
    private final Map<ClassPath, CacheEntry> cacheEntries = Maps.newConcurrentMap();
    private final Set<CachedClassLoader> inUseClassLoaders = Sets.newHashSet();
    private final GroovySystemLoaderFactory groovySystemLoaderFactory;

    public ClassPathToClassLoaderCache(GroovySystemLoaderFactory groovySystemLoaderFactory) {
        this.groovySystemLoaderFactory = groovySystemLoaderFactory;
        this.finalizerThread = new FinalizerThread(this.cacheEntries, this.lock);
        this.finalizerThread.start();
    }

    public void stop() {
        this.finalizerThread.exit();
        try {
            this.finalizerThread.join();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public int size() {
        return this.cacheEntries.size();
    }

    public boolean isEmpty() {
        return this.cacheEntries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCachedClassLoader(ClassPath libClasspath, GroovySystemLoader gradleApiGroovy, GroovySystemLoader antBuilderAdapterGroovy, Factory<? extends ClassLoader> factory, Action<? super CachedClassLoader> action) {
        CachedClassLoader cachedClassLoader;
        this.lock.lock();
        try {
            CacheEntry cacheEntry = this.cacheEntries.get(libClasspath);
            cachedClassLoader = this.maybeGet(cacheEntry);
            if (cachedClassLoader == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Classloader cache miss for classpath : {}. Creating classloader.", (Object)libClasspath.getAsURIs());
                }
                ClassLoader classLoader = (ClassLoader)factory.create();
                cachedClassLoader = new CachedClassLoader(libClasspath, classLoader);
                cacheEntry = new CacheEntry(libClasspath, cachedClassLoader);
                GroovySystemLoader groovySystemForLoader = this.groovySystemLoaderFactory.forClassLoader(classLoader);
                Cleanup cleanup = new Cleanup(libClasspath, cachedClassLoader, this.finalizerThread.getReferenceQueue(), classLoader, groovySystemForLoader, gradleApiGroovy, antBuilderAdapterGroovy);
                this.finalizerThread.putCleanup(libClasspath, cleanup);
                this.cacheEntries.put(libClasspath, cacheEntry);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Classloader found in cache: {}", (Object)libClasspath.getAsURIs());
            }
            this.inUseClassLoaders.add(cachedClassLoader);
        }
        finally {
            this.lock.unlock();
        }
        try {
            action.execute((Object)cachedClassLoader);
        }
        finally {
            this.lock.lock();
            try {
                this.inUseClassLoaders.remove(cachedClassLoader);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private CachedClassLoader maybeGet(CacheEntry cacheEntry) {
        return cacheEntry != null ? (CachedClassLoader)cacheEntry.get() : null;
    }
}

