/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public final class MutableClosure
implements CalculatedClosure {
    private final ClassDescriptor closureClass;
    private final ClassDescriptor enclosingClass;
    private final CallableDescriptor enclosingFunWithReceiverDescriptor;
    private boolean captureThis;
    private boolean captureEnclosingReceiver;
    private Map<DeclarationDescriptor, EnclosedValueDescriptor> captureVariables;
    private Map<DeclarationDescriptor, Integer> parameterOffsetInConstructor;
    private List<Pair<String, Type>> recordedFields;
    private KotlinType captureReceiverType;
    private boolean isSuspend;
    private boolean isSuspendLambda;

    MutableClosure(@NotNull ClassDescriptor classDescriptor2, @Nullable ClassDescriptor enclosingClass) {
        this.closureClass = classDescriptor2;
        this.enclosingClass = enclosingClass;
        this.enclosingFunWithReceiverDescriptor = MutableClosure.enclosingExtensionMemberForClass(classDescriptor2);
    }

    @Nullable
    private static CallableDescriptor enclosingExtensionMemberForClass(@NotNull ClassDescriptor classDescriptor2) {
        CallableMemberDescriptor member;
        DeclarationDescriptor classContainer = classDescriptor2.getContainingDeclaration();
        if (classContainer instanceof CallableMemberDescriptor && (member = JvmCodegenUtil.getDirectMember((CallableMemberDescriptor)classContainer)).getExtensionReceiverParameter() != null) {
            return member;
        }
        return null;
    }

    @Override
    @NotNull
    public ClassDescriptor getClosureClass() {
        return this.closureClass;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public ClassDescriptor getCapturedOuterClassDescriptor() {
        return this.captureThis ? this.enclosingClass : null;
    }

    public void setNeedsCaptureOuterClass() {
        this.captureThis = true;
    }

    @Override
    public KotlinType getCapturedReceiverFromOuterContext() {
        if (this.captureReceiverType != null) {
            return this.captureReceiverType;
        }
        if (this.captureEnclosingReceiver) {
            ReceiverParameterDescriptor parameter = this.getEnclosingReceiverDescriptor();
            assert (parameter != null) : "Receiver parameter should exist in " + this.enclosingFunWithReceiverDescriptor;
            return parameter.getType();
        }
        return null;
    }

    @Override
    @NotNull
    public String getCapturedReceiverFieldName(BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
        if (this.captureReceiverType != null) {
            return "receiver$0";
        }
        if (this.enclosingFunWithReceiverDescriptor != null) {
            if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
                return "receiver$0";
            }
            String labeledThis = AsmUtil.getLabeledThisNameForReceiver(this.enclosingFunWithReceiverDescriptor, bindingContext, languageVersionSettings);
            return AsmUtil.getCapturedFieldName(labeledThis);
        }
        throw new IllegalStateException("Closure does not capture an outer receiver");
    }

    public void setNeedsCaptureReceiverFromOuterContext() {
        if (this.enclosingFunWithReceiverDescriptor == null) {
            throw new IllegalStateException("Extension receiver parameter should exist");
        }
        this.captureEnclosingReceiver = true;
    }

    public void setCustomCapturedReceiverType(@NotNull KotlinType type2) {
        this.captureReceiverType = type2;
    }

    @Override
    @NotNull
    public Map<DeclarationDescriptor, EnclosedValueDescriptor> getCaptureVariables() {
        return this.captureVariables != null ? this.captureVariables : Collections.emptyMap();
    }

    @Override
    @NotNull
    public List<Pair<String, Type>> getRecordedFields() {
        return this.recordedFields != null ? this.recordedFields : Collections.emptyList();
    }

    @Override
    public boolean isSuspend() {
        return this.isSuspend;
    }

    public void setSuspend(boolean suspend) {
        this.isSuspend = suspend;
    }

    @Override
    public boolean isSuspendLambda() {
        return this.isSuspendLambda;
    }

    public void setSuspendLambda() {
        this.isSuspendLambda = true;
    }

    private void recordField(String name, Type type2) {
        if (this.recordedFields == null) {
            this.recordedFields = new LinkedList<Pair<String, Type>>();
        }
        this.recordedFields.add(new Pair<String, Type>(name, type2));
    }

    public void captureVariable(EnclosedValueDescriptor value) {
        this.recordField(value.getFieldName(), value.getType());
        if (this.captureVariables == null) {
            this.captureVariables = new LinkedHashMap<DeclarationDescriptor, EnclosedValueDescriptor>();
        }
        this.captureVariables.put(value.getDescriptor(), value);
    }

    public void setCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2, int offset2) {
        if (this.parameterOffsetInConstructor == null) {
            this.parameterOffsetInConstructor = new LinkedHashMap<DeclarationDescriptor, Integer>();
        }
        this.parameterOffsetInConstructor.put(descriptor2, offset2);
    }

    public int getCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2) {
        Integer result2 = this.parameterOffsetInConstructor != null ? this.parameterOffsetInConstructor.get(descriptor2) : null;
        return result2 != null ? result2 : -1;
    }

    @Nullable
    public ReceiverParameterDescriptor getEnclosingReceiverDescriptor() {
        return this.enclosingFunWithReceiverDescriptor != null ? this.enclosingFunWithReceiverDescriptor.getExtensionReceiverParameter() : null;
    }
}

