/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers.hash;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.HashUtil;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Entry<K, V>[] table;
    private int capacity;
    private int size;
    private final float loadFactor;

    public HashMap() {
        this(0);
    }

    public HashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public HashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.clear(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clear(0);
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
                return (V)e.value;
            }
            e = e.hashNext;
        }
        return null;
    }

    @Override
    public V put(K key, @NotNull V value) {
        if (value == null) {
            HashMap.$$$reportNull$$$0(0);
        }
        Entry<K, V>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
                return e.setValue(value);
            }
            e = e.hashNext;
        }
        e = new Entry<K, V>(key, value);
        e.hashNext = (Entry)table[index2];
        table[index2] = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V remove(Object key) {
        Object entryKey;
        Entry<K, V>[] table = this.table;
        int hash = HashUtil.hash(key);
        int index2 = hash % table.length;
        Entry e = table[index2];
        if (e == null) {
            return null;
        }
        if (e.keyHash == hash && ((entryKey = e.key) == key || entryKey.equals(key))) {
            table[index2] = e.hashNext;
        } else {
            Entry last2;
            do {
                last2 = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.keyHash != hash || (entryKey = e.key) != key && !entryKey.equals(key));
            last2.hashNext = e.hashNext;
        }
        --this.size;
        return (V)e.value;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        KeySet keySet = new KeySet();
        if (keySet == null) {
            HashMap.$$$reportNull$$$0(1);
        }
        return keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Values values = new Values();
        if (values == null) {
            HashMap.$$$reportNull$$$0(2);
        }
        return values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = new EntrySet();
        if (entrySet == null) {
            HashMap.$$$reportNull$$$0(3);
        }
        return entrySet;
    }

    private void init(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    private void rehash(int capacity) {
        Iterator<Map.Entry<K, V>> entries2 = this.entrySet().iterator();
        this.init(capacity);
        Entry<K, V>[] table = this.table;
        int tableLen = table.length;
        while (entries2.hasNext()) {
            Entry e = (Entry)entries2.next();
            int hash = e.keyHash % tableLen;
            e.hashNext = (Entry)table[hash];
            table[hash] = e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            HashIterator hashIterator = new HashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
            if (hashIterator == null) {
                Values.$$$reportNull$$$0(0);
            }
            return hashIterator;
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashMap$Values", "iterator"));
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            HashIterator hashIterator = new HashIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().key;
                }
            };
            if (hashIterator == null) {
                KeySet.$$$reportNull$$$0(0);
            }
            return hashIterator;
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return HashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashMap$KeySet", "iterator"));
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            HashIterator hashIterator = new HashIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
            if (hashIterator == null) {
                EntrySet.$$$reportNull$$$0(0);
            }
            return hashIterator;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = HashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return HashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/hash/HashMap$EntrySet", "iterator"));
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private final Entry<K, V>[] table;
        private int index;
        private Entry<K, V> e;
        private Entry<K, V> last;

        HashIterator() {
            this.table = HashMap.this.table;
            this.index = 0;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.initNextEntry();
            return result2;
        }

        private void initNextEntry() {
            Entry result2 = this.e;
            if (result2 != null) {
                result2 = result2.hashNext;
            }
            Entry<K, V>[] table = this.table;
            while (result2 == null && this.index < table.length) {
                result2 = table[this.index++];
            }
            this.e = result2;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int keyHash;
        private V value;
        private Entry<K, V> hashNext;

        public Entry(K key, V value) {
            this.key = key;
            this.keyHash = HashUtil.hash(key);
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result2 = this.value;
            this.value = value;
            return result2;
        }
    }
}

