/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;

public abstract class AbstractDynamicObject
implements DynamicObject {
    public abstract String getDisplayName();

    public String toString() {
        return "DynamicObject for " + this.getDisplayName();
    }

    @Override
    public boolean hasProperty(String name) {
        return false;
    }

    @Override
    public DynamicInvokeResult tryGetProperty(String name) {
        return DynamicInvokeResult.notFound();
    }

    @Nullable
    public Class<?> getPublicType() {
        return null;
    }

    public boolean hasUsefulDisplayName() {
        return true;
    }

    @Override
    public Object getProperty(String name) throws MissingPropertyException {
        DynamicInvokeResult result = this.tryGetProperty(name);
        if (!result.isFound()) {
            throw this.getMissingProperty(name);
        }
        return result.getValue();
    }

    @Override
    public DynamicInvokeResult trySetProperty(String name, Object value) {
        return DynamicInvokeResult.notFound();
    }

    @Override
    public void setProperty(String name, Object value) throws MissingPropertyException {
        DynamicInvokeResult result = this.trySetProperty(name, value);
        if (!result.isFound()) {
            throw this.setMissingProperty(name);
        }
    }

    @Override
    public MissingPropertyException getMissingProperty(String name) {
        Class<?> publicType = this.getPublicType();
        boolean includeDisplayName = this.hasUsefulDisplayName();
        if (publicType != null && includeDisplayName) {
            return new MissingPropertyException(String.format("Could not get unknown property '%s' for %s of type %s.", name, this.getDisplayName(), publicType.getName()), name, publicType);
        }
        if (publicType != null) {
            return new MissingPropertyException(String.format("Could not get unknown property '%s' for object of type %s.", name, publicType.getName()), name, publicType);
        }
        return new MissingPropertyException(String.format("Could not get unknown property '%s' for %s.", name, this.getDisplayName()), name, null);
    }

    protected GroovyRuntimeException getWriteOnlyProperty(String name) {
        Class<?> publicType = this.getPublicType();
        boolean includeDisplayName = this.hasUsefulDisplayName();
        if (publicType != null && includeDisplayName) {
            return new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' for %s of type %s.", name, this.getDisplayName(), publicType.getName()));
        }
        if (publicType != null) {
            return new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' for object of type %s.", name, publicType.getName()));
        }
        return new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' for %s.", name, this.getDisplayName()));
    }

    @Override
    public MissingPropertyException setMissingProperty(String name) {
        Class<?> publicType = this.getPublicType();
        boolean includeDisplayName = this.hasUsefulDisplayName();
        if (publicType != null && includeDisplayName) {
            return new MissingPropertyException(String.format("Could not set unknown property '%s' for %s of type %s.", name, this.getDisplayName(), publicType.getName()), name, publicType);
        }
        if (publicType != null) {
            return new MissingPropertyException(String.format("Could not set unknown property '%s' for object of type %s.", name, publicType.getName()), name, publicType);
        }
        return new MissingPropertyException(String.format("Could not set unknown property '%s' for %s.", name, this.getDisplayName()), name, null);
    }

    protected GroovyRuntimeException setReadOnlyProperty(String name) {
        Class<?> publicType = this.getPublicType();
        boolean includeDisplayName = this.hasUsefulDisplayName();
        if (publicType != null && includeDisplayName) {
            return new GroovyRuntimeException(String.format("Cannot set the value of read-only property '%s' for %s of type %s.", name, this.getDisplayName(), publicType.getName()));
        }
        if (publicType != null) {
            return new GroovyRuntimeException(String.format("Cannot set the value of read-only property '%s' for object of type %s.", name, publicType.getName()));
        }
        return new GroovyRuntimeException(String.format("Cannot set the value of read-only property '%s' for %s.", name, this.getDisplayName()));
    }

    @Override
    public Map<String, ?> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        return false;
    }

    @Override
    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        return DynamicInvokeResult.notFound();
    }

    @Override
    public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
        DynamicInvokeResult result = this.tryInvokeMethod(name, arguments);
        if (result.isFound()) {
            return result.getValue();
        }
        throw this.methodMissingException(name, arguments);
    }

    @Override
    public MissingMethodException methodMissingException(String name, Object ... params) {
        Class<?> publicType = this.getPublicType();
        boolean includeDisplayName = this.hasUsefulDisplayName();
        String message = publicType != null && includeDisplayName ? String.format("Could not find method %s() for arguments %s on %s of type %s.", name, Arrays.toString(params), this.getDisplayName(), publicType.getName()) : (publicType != null ? String.format("Could not find method %s() for arguments %s on object of type %s.", name, Arrays.toString(params), publicType.getName()) : String.format("Could not find method %s() for arguments %s on %s.", name, Arrays.toString(params), this.getDisplayName()));
        return new CustomMessageMissingMethodException(name, publicType, message, params);
    }

    private static class CustomMessageMissingMethodException
    extends MissingMethodException {
        private final String message;

        CustomMessageMissingMethodException(String name, Class<?> publicType, String message, Object ... params) {
            super(name, publicType, params);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

