/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.gradle.api.Action;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ObjectGraphAdapter;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.connection.AbstractBuildController;
import org.gradle.tooling.internal.consumer.connection.InternalBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.connection.ToolingParameterProxy;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.internal.Exceptions;

class BuildControllerAdapter
extends AbstractBuildController
implements BuildController {
    private final InternalBuildControllerAdapter buildController;
    private final ProtocolToModelAdapter adapter;
    private final ObjectGraphAdapter resultAdapter;
    private final ModelMapping modelMapping;
    private final File rootDir;

    public BuildControllerAdapter(ProtocolToModelAdapter adapter, InternalBuildControllerAdapter buildController, ModelMapping modelMapping, File rootDir) {
        this.adapter = adapter;
        this.buildController = buildController;
        this.modelMapping = modelMapping;
        this.rootDir = rootDir;
        this.resultAdapter = adapter.newGraph();
    }

    @Override
    public <T, P> T getModel(Model target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws UnsupportedVersionException {
        BuildResult<?> result;
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(modelType);
        Object originalTarget = target == null ? null : this.adapter.unpack(target);
        P parameter = this.initializeParameter(parameterType, parameterInitializer);
        try {
            result = this.buildController.getModel(originalTarget, modelIdentifier, parameter);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(modelType, e);
        }
        ViewBuilder<T> viewBuilder = this.resultAdapter.builder(modelType);
        this.applyCompatibilityMapping(viewBuilder, new DefaultProjectIdentifier(this.rootDir, this.getProjectPath(target)));
        return viewBuilder.build(result.getModel());
    }

    private <P> P initializeParameter(Class<P> parameterType, Action<? super P> parameterInitializer) {
        this.validateParameters(parameterType, parameterInitializer);
        if (parameterType != null) {
            P parameter = parameterType.cast(Proxy.newProxyInstance(parameterType.getClassLoader(), new Class[]{parameterType}, (InvocationHandler)new ToolingParameterProxy()));
            parameterInitializer.execute(parameter);
            return parameter;
        }
        return null;
    }

    private <P> void validateParameters(Class<P> parameterType, Action<? super P> parameterInitializer) {
        if (parameterType == null && parameterInitializer != null || parameterType != null && parameterInitializer == null) {
            throw new NullPointerException("parameterType and parameterInitializer both need to be set for a parametrized model request.");
        }
        if (parameterType != null) {
            ToolingParameterProxy.validateParameter(parameterType);
        }
    }

    private String getProjectPath(Model target) {
        if (target instanceof ProjectModel) {
            return ((ProjectModel)((Object)target)).getProjectIdentifier().getProjectPath();
        }
        return ":";
    }
}

