/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;

class DefaultPendingDependenciesVisitor
implements PendingDependenciesVisitor {
    private final ResolveState resolveState;
    private List<PendingDependencies> noLongerPending;

    DefaultPendingDependenciesVisitor(ResolveState resolveState) {
        this.resolveState = resolveState;
    }

    @Override
    public boolean maybeAddAsPendingDependency(NodeState node, DependencyState dependencyState) {
        ModuleIdentifier key = dependencyState.getModuleIdentifier();
        boolean isConstraint = dependencyState.getDependency().isConstraint();
        if (!isConstraint) {
            this.markNotPending(key);
            return false;
        }
        ModuleResolveState module = this.resolveState.getModule(key);
        boolean pending = module.isPending();
        if (!pending) {
            return false;
        }
        module.addPendingNode(node);
        return true;
    }

    @Override
    public void markNotPending(ModuleIdentifier id) {
        this.markNoLongerPending(this.resolveState.getModule(id).getPendingDependencies());
    }

    private void markNoLongerPending(PendingDependencies pendingDependencies) {
        if (pendingDependencies.hasPendingComponents()) {
            if (this.noLongerPending == null) {
                this.noLongerPending = Lists.newLinkedList();
            }
            this.noLongerPending.add(pendingDependencies);
        }
        pendingDependencies.increaseHardEdgeCount();
    }

    @Override
    public void complete() {
        if (this.noLongerPending != null) {
            for (PendingDependencies pendingDependencies : this.noLongerPending) {
                pendingDependencies.turnIntoHardDependencies();
            }
            this.noLongerPending = null;
        }
    }
}

