/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;

public interface CacheKeyBuilder {
    public String build(CacheKeySpec var1);

    public static class CacheKeySpec {
        private final String prefix;
        private final Object[] components;

        public static CacheKeySpec withPrefix(String prefix) {
            if (prefix == null || prefix.isEmpty()) {
                throw new IllegalArgumentException("Cache key prefix cannot be null or empty.");
            }
            return new CacheKeySpec(prefix, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        private CacheKeySpec(String prefix, Object[] components) {
            this.prefix = prefix;
            this.components = components;
        }

        public CacheKeySpec plus(String s) {
            return this.plusComponent(s);
        }

        public CacheKeySpec plus(File f) {
            return this.plusComponent(f);
        }

        public CacheKeySpec plus(ClassPath cp) {
            return this.plusComponent(cp);
        }

        public CacheKeySpec plus(ClassLoader cl) {
            return this.plusComponent(cl);
        }

        public CacheKeySpec plus(HashCode hashCode) {
            return this.plusComponent(hashCode);
        }

        String getPrefix() {
            return this.prefix;
        }

        Object[] getComponents() {
            return this.components;
        }

        private CacheKeySpec plusComponent(Object c) {
            if (c == null) {
                throw new IllegalArgumentException("Cache key component cannot be null.");
            }
            return new CacheKeySpec(this.prefix, ArrayUtils.add((Object[])this.components, (Object)c));
        }
    }
}

