/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.DefaultCompilerVersion;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.nativeplatform.internal.BinaryToolSpec;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.AbstractPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultMutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.EmptySystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.Stripper;
import org.gradle.nativeplatform.toolchain.internal.SymbolExtractor;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.gcc.ArStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.gcc.Assembler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccLinker;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCppCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolRegistry;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.process.internal.ExecActionFactory;

class GccPlatformToolProvider
extends AbstractPlatformToolProvider {
    private static final Map<ToolType, String> LANGUAGE_FOR_COMPILER = ImmutableMap.of((Object)((Object)ToolType.C_COMPILER), (Object)"c", (Object)((Object)ToolType.CPP_COMPILER), (Object)"c++", (Object)((Object)ToolType.OBJECTIVEC_COMPILER), (Object)"objective-c", (Object)((Object)ToolType.OBJECTIVECPP_COMPILER), (Object)"objective-c++");
    private final ToolSearchPath toolSearchPath;
    private final ToolRegistry toolRegistry;
    private final ExecActionFactory execActionFactory;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final boolean useCommandFile;
    private final WorkerLeaseService workerLeaseService;
    private final CompilerMetaDataProvider<GccMetadata> metadataProvider;

    GccPlatformToolProvider(BuildOperationExecutor buildOperationExecutor, OperatingSystemInternal targetOperatingSystem, ToolSearchPath toolSearchPath, ToolRegistry toolRegistry, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, boolean useCommandFile, WorkerLeaseService workerLeaseService, CompilerMetaDataProvider<GccMetadata> metadataProvider) {
        super(buildOperationExecutor, targetOperatingSystem);
        this.toolRegistry = toolRegistry;
        this.toolSearchPath = toolSearchPath;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.useCommandFile = useCommandFile;
        this.execActionFactory = execActionFactory;
        this.workerLeaseService = workerLeaseService;
        this.metadataProvider = metadataProvider;
    }

    @Override
    public CommandLineToolSearchResult locateTool(ToolType compilerType) {
        return this.toolSearchPath.locate(compilerType, this.toolRegistry.getTool(compilerType).getExecutable());
    }

    protected Compiler<CppCompileSpec> createCppCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppCompiler cppCompiler = new CppCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cppCompilerTool), this.context(cppCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CppCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.CPP_COMPILER);
    }

    @Override
    protected Compiler<?> createCppPCHCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppPCHCompiler cppPCHCompiler = new CppPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cppCompilerTool), this.context(cppCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CppPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppPCHCompileSpec>(cppPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.CPP_COMPILER);
    }

    private <T extends BinaryToolSpec> VersionAwareCompiler<T> versionAwareCompiler(Compiler<T> compiler, ToolType toolType) {
        SearchResult<GccMetadata> gccMetadata = this.getGccMetadata(toolType);
        return new VersionAwareCompiler(compiler, (CompilerVersion)new DefaultCompilerVersion(this.metadataProvider.getCompilerType().getIdentifier(), ((GccMetadata)gccMetadata.getComponent()).getVendor(), ((GccMetadata)gccMetadata.getComponent()).getVersion()));
    }

    protected Compiler<CCompileSpec> createCCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CCompiler cCompiler = new CCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cCompilerTool), this.context(cCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.C_COMPILER);
    }

    @Override
    protected Compiler<?> createCPCHCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CPCHCompiler cpchCompiler = new CPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cCompilerTool), this.context(cCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CPCHCompileSpec>(cpchCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.C_COMPILER);
    }

    protected Compiler<ObjectiveCppCompileSpec> createObjectiveCppCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppCompiler objectiveCppCompiler = new ObjectiveCppCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCppCompilerTool), this.context(objectiveCppCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCppCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCppCompileSpec>(objectiveCppCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.OBJECTIVECPP_COMPILER);
    }

    @Override
    protected Compiler<?> createObjectiveCppPCHCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppPCHCompiler objectiveCppPCHCompiler = new ObjectiveCppPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCppCompilerTool), this.context(objectiveCppCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCppPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCppPCHCompileSpec>(objectiveCppPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.OBJECTIVECPP_COMPILER);
    }

    protected Compiler<ObjectiveCCompileSpec> createObjectiveCCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCCompiler objectiveCCompiler = new ObjectiveCCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCCompilerTool), this.context(objectiveCCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCCompileSpec>(objectiveCCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.OBJECTIVEC_COMPILER);
    }

    @Override
    protected Compiler<?> createObjectiveCPCHCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCPCHCompiler objectiveCPCHCompiler = new ObjectiveCPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCCompilerTool), this.context(objectiveCCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCPCHCompileSpec>(objectiveCPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler, ToolType.OBJECTIVEC_COMPILER);
    }

    protected Compiler<AssembleSpec> createAssembler() {
        GccCommandLineToolConfigurationInternal assemblerTool = this.toolRegistry.getTool(ToolType.ASSEMBLER);
        return new Assembler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(assemblerTool), this.context(assemblerTool), this.getObjectFileExtension(), false, this.workerLeaseService);
    }

    protected Compiler<LinkerSpec> createLinker() {
        GccCommandLineToolConfigurationInternal linkerTool = this.toolRegistry.getTool(ToolType.LINKER);
        return this.versionAwareCompiler(new GccLinker(this.buildOperationExecutor, this.commandLineTool(linkerTool), this.context(linkerTool), this.useCommandFile, this.workerLeaseService), ToolType.LINKER);
    }

    protected Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        GccCommandLineToolConfigurationInternal staticLibArchiverTool = this.toolRegistry.getTool(ToolType.STATIC_LIB_ARCHIVER);
        return new ArStaticLibraryArchiver(this.buildOperationExecutor, this.commandLineTool(staticLibArchiverTool), this.context(staticLibArchiverTool), this.workerLeaseService);
    }

    @Override
    protected Compiler<?> createSymbolExtractor() {
        GccCommandLineToolConfigurationInternal symbolExtractor = this.toolRegistry.getTool(ToolType.SYMBOL_EXTRACTOR);
        return new SymbolExtractor(this.buildOperationExecutor, this.commandLineTool(symbolExtractor), this.context(symbolExtractor), this.workerLeaseService);
    }

    @Override
    protected Compiler<?> createStripper() {
        GccCommandLineToolConfigurationInternal stripper = this.toolRegistry.getTool(ToolType.STRIPPER);
        return new Stripper(this.buildOperationExecutor, this.commandLineTool(stripper), this.context(stripper), this.workerLeaseService);
    }

    private CommandLineToolInvocationWorker commandLineTool(GccCommandLineToolConfigurationInternal tool) {
        ToolType key = tool.getToolType();
        String exeName = tool.getExecutable();
        return new DefaultCommandLineToolInvocationWorker(key.getToolName(), this.toolSearchPath.locate(key, exeName).getTool(), this.execActionFactory);
    }

    private CommandLineToolContext context(GccCommandLineToolConfigurationInternal toolConfiguration) {
        DefaultMutableCommandLineToolContext baseInvocation = new DefaultMutableCommandLineToolContext();
        baseInvocation.addPath(this.toolSearchPath.getPath());
        baseInvocation.addEnvironmentVar("CYGWIN", "nodosfilewarning");
        baseInvocation.setArgAction(toolConfiguration.getArgAction());
        return baseInvocation;
    }

    private String getPCHFileExtension() {
        return ".h.gch";
    }

    private SearchResult<GccMetadata> getGccMetadata(ToolType compilerType) {
        GccCommandLineToolConfigurationInternal compiler = this.toolRegistry.getTool(compilerType);
        if (compiler == null) {
            return new ComponentNotFound("Tool " + compilerType.getToolName() + " is not available");
        }
        CommandLineToolSearchResult searchResult = this.toolSearchPath.locate(compiler.getToolType(), compiler.getExecutable());
        String language = LANGUAGE_FOR_COMPILER.get((Object)compilerType);
        ImmutableList languageArgs = language == null ? Collections.emptyList() : ImmutableList.of((Object)"-x", (Object)language);
        return this.metadataProvider.getCompilerMetaData(this.toolSearchPath.getPath(), (Action<CompilerMetaDataProvider.CompilerExecSpec>)((Action)arg_0 -> GccPlatformToolProvider.lambda$getGccMetadata$0(searchResult, (List)languageArgs, arg_0)));
    }

    @Override
    public SystemLibraries getSystemLibraries(ToolType compilerType) {
        SearchResult<GccMetadata> gccMetadata = this.getGccMetadata(compilerType);
        if (gccMetadata.isAvailable()) {
            return ((GccMetadata)gccMetadata.getComponent()).getSystemLibraries();
        }
        return new EmptySystemLibraries();
    }

    @Override
    public CompilerMetadata getCompilerMetadata(ToolType toolType) {
        return (CompilerMetadata)this.getGccMetadata(toolType).getComponent();
    }

    private static /* synthetic */ void lambda$getGccMetadata$0(CommandLineToolSearchResult searchResult, List languageArgs, CompilerMetaDataProvider.CompilerExecSpec spec) {
        spec.executable(searchResult.getTool()).args(languageArgs);
    }
}

