/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.internal.Factory;
import org.gradle.util.ConfigureUtil;

public class SimpleReport
implements ConfigurableReport {
    private String name;
    private Factory<String> displayName;
    private final Property<File> destination;
    private final Property<Boolean> enabled;
    private Report.OutputType outputType;

    public SimpleReport(String name, Factory<String> displayName, Report.OutputType outputType, Project project) {
        this.name = name;
        this.displayName = displayName;
        this.outputType = outputType;
        this.destination = project.getObjects().property(File.class);
        this.enabled = project.getObjects().property(Boolean.class).value((Object)false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return (String)this.displayName.create();
    }

    public String toString() {
        return "Report " + this.getName();
    }

    @Override
    public File getDestination() {
        return (File)this.destination.getOrNull();
    }

    @Override
    public void setDestination(File file) {
        this.destination.set((Object)file);
    }

    @Override
    public void setDestination(Provider<File> provider) {
        this.destination.set(provider);
    }

    @Override
    public Report.OutputType getOutputType() {
        return this.outputType;
    }

    public Report configure(Closure configure) {
        return (Report)ConfigureUtil.configureSelf((Closure)configure, (Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.set((Object)enabled);
    }

    @Override
    public void setEnabled(Provider<Boolean> enabled) {
        this.enabled.set(enabled);
    }
}

