/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.swiftpm.internal.NativeProjectPublication;
import org.gradle.swiftpm.internal.SwiftPmTarget;

@Incubating
@NonNullApi
public class CppBasePlugin
implements Plugin<Project> {
    private final ProjectPublicationRegistry publicationRegistry;

    @Inject
    public CppBasePlugin(ProjectPublicationRegistry publicationRegistry) {
        this.publicationRegistry = publicationRegistry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        TaskContainer tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        ((FeaturePreviews)((GradleInternal)project.getGradle()).getServices().get(FeaturePreviews.class)).enableFeature(FeaturePreviews.Feature.GRADLE_METADATA);
        project.getComponents().withType(DefaultCppBinary.class, binary -> {
            Names names = binary.getNames();
            String language = "cpp";
            TaskProvider compile = tasks.register(names.getCompileTaskName(language), CppCompile.class, task -> {
                Callable<List> systemIncludes = () -> binary.getPlatformToolProvider().getSystemLibraries(ToolType.CPP_COMPILER).getIncludeDirs();
                task.includes(binary.getCompileIncludePath());
                task.getSystemIncludes().from(new Object[]{systemIncludes});
                task.source(binary.getCppSource());
                if (binary.isDebuggable()) {
                    task.setDebuggable(true);
                }
                if (binary.isOptimized()) {
                    task.setOptimized(true);
                }
                task.getTargetPlatform().set((Object)binary.getNativePlatform());
                task.getToolChain().set((Object)binary.getToolChain());
                task.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                if (binary instanceof CppSharedLibrary) {
                    task.setPositionIndependentCode(true);
                }
            });
            binary.getObjectsDir().set(compile.flatMap(task -> task.getObjectFileDir()));
            binary.getCompileTask().set((Provider)compile);
        });
        project.getComponents().withType(ProductionCppComponent.class, component -> project.afterEvaluate(p -> {
            DefaultCppComponent componentInternal = (DefaultCppComponent)((Object)component);
            this.publicationRegistry.registerPublication((ProjectInternal)project, (ProjectPublication)new NativeProjectPublication(componentInternal.getDisplayName(), new SwiftPmTarget((String)component.getBaseName().get())));
        }));
    }
}

