/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class ImmutableManagedValueSnapshot
implements ValueSnapshot {
    private final String className;
    private final String value;

    public ImmutableManagedValueSnapshot(String className, String value) {
        this.className = className;
        this.value = value;
    }

    public String getClassName() {
        return this.className;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public ValueSnapshot snapshot(@Nullable Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (this.equals(snapshot)) {
            return this;
        }
        return snapshot;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImmutableManagedValueSnapshot other = (ImmutableManagedValueSnapshot)obj;
        return other.className.equals(this.className) && other.value.equals(this.value);
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.value.hashCode();
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.className);
        hasher.putString((CharSequence)this.value);
    }
}

