/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.kotlin.dsl.accessors.AccessorNameSpec;
import org.gradle.kotlin.dsl.accessors.CodeGeneratorKt;
import org.gradle.kotlin.dsl.accessors.ProjectSchemaEntry;
import org.gradle.kotlin.dsl.accessors.TypeAccessibility;
import org.gradle.kotlin.dsl.accessors.TypedAccessorSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a \u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a \u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a \u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002\u001a\u0010\u0010#\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002\u001a\u0018\u0010&\u001a\u0004\u0018\u00010\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"invalidNameChars", "", "thisConvention", "", "thisExtensions", "accessibleConventionAccessorFor", "targetType", "name", "Lorg/gradle/kotlin/dsl/accessors/AccessorNameSpec;", "type", "accessibleExistingContainerElementAccessorFor", "accessibleExistingTaskAccessorFor", "accessibleExtensionAccessorFor", "accessorNameSpec", "originalName", "conventionAccessor", "spec", "Lorg/gradle/kotlin/dsl/accessors/TypedAccessorSpec;", "documentInaccessibilityReasons", "typeAccess", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility$Inaccessible;", "escapeStringTemplateDollarSign", "string", "existingContainerElementAccessor", "existingTaskAccessor", "extensionAccessor", "inaccessibleConventionAccessorFor", "inaccessibleExistingContainerElementAccessorFor", "containerType", "elementType", "inaccessibleExistingTaskAccessorFor", "inaccessibleExtensionAccessorFor", "isKotlinIdentifier", "", "candidate", "isLegalAccessorName", "stringLiteralFor", "original", "typedAccessorSpec", "schemaEntry", "Lorg/gradle/kotlin/dsl/accessors/ProjectSchemaEntry;", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility;", "gradle-kotlin-dsl"})
public final class CodeGeneratorKt {
    private static final String thisExtensions = "(this as " + ExtensionAware.class.getName() + ").extensions";
    private static final String thisConvention = "((this as? Project)?.convention ?: (this as " + HasConvention.class.getName() + ").convention)";
    private static final char[] invalidNameChars = new char[]{'.', '/', '\\'};

    @NotNull
    public static final String extensionAccessor(@NotNull TypedAccessorSpec spec) {
        String string2;
        TypedAccessorSpec typedAccessorSpec;
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TypedAccessorSpec $receiver = typedAccessorSpec = spec;
        boolean bl = false;
        TypeAccessibility typeAccessibility = $receiver.getType();
        if (typeAccessibility instanceof TypeAccessibility.Accessible) {
            string2 = CodeGeneratorKt.accessibleExtensionAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), ((TypeAccessibility.Accessible)$receiver.getType()).getType().getKotlinString());
        } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
            string2 = CodeGeneratorKt.inaccessibleExtensionAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), (TypeAccessibility.Inaccessible)$receiver.getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String accessibleExtensionAccessorFor(String targetType, AccessorNameSpec name2, String type2) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Retrieves the [" + $receiver.getOriginal() + "][" + type2 + "] extension.\n         */\n        val " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`: " + type2 + " get() =\n            " + thisExtensions + ".getByName(\"" + $receiver.getStringLiteral() + "\") as " + type2 + "\n\n        /**\n         * Configures the [" + $receiver.getOriginal() + "][" + type2 + "] extension.\n         */\n        fun " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`(configure: " + type2 + ".() -> Unit): Unit =\n            " + thisExtensions + ".configure(\"" + $receiver.getStringLiteral() + "\", configure)\n    ";
    }

    private static final String inaccessibleExtensionAccessorFor(String targetType, AccessorNameSpec name2, TypeAccessibility.Inaccessible typeAccess) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Retrieves the `" + $receiver.getOriginal() + "` extension.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, typeAccess) + "\n         */\n        val " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`: Any get() =\n            " + thisExtensions + ".getByName(\"" + $receiver.getStringLiteral() + "\")\n\n        /**\n         * Configures the `" + $receiver.getOriginal() + "` extension.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, typeAccess) + "\n         */\n        fun " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`(configure: Any.() -> Unit): Unit =\n            " + thisExtensions + ".configure(\"" + $receiver.getStringLiteral() + "\", configure)\n\n    ";
    }

    @NotNull
    public static final String conventionAccessor(@NotNull TypedAccessorSpec spec) {
        String string2;
        TypedAccessorSpec typedAccessorSpec;
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TypedAccessorSpec $receiver = typedAccessorSpec = spec;
        boolean bl = false;
        TypeAccessibility typeAccessibility = $receiver.getType();
        if (typeAccessibility instanceof TypeAccessibility.Accessible) {
            string2 = CodeGeneratorKt.accessibleConventionAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), ((TypeAccessibility.Accessible)$receiver.getType()).getType().getKotlinString());
        } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
            string2 = CodeGeneratorKt.inaccessibleConventionAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), (TypeAccessibility.Inaccessible)$receiver.getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String accessibleConventionAccessorFor(String targetType, AccessorNameSpec name2, String type2) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Retrieves the [" + $receiver.getOriginal() + "][" + type2 + "] convention.\n         */\n        val " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`: " + type2 + " get() =\n            " + thisConvention + ".getPluginByName<" + type2 + ">(\"" + $receiver.getStringLiteral() + "\")\n\n        /**\n         * Configures the [" + $receiver.getOriginal() + "][" + type2 + "] convention.\n         */\n        fun " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`(configure: " + type2 + ".() -> Unit): Unit =\n            configure(`" + $receiver.getStringLiteral() + "`)\n\n    ";
    }

    private static final String inaccessibleConventionAccessorFor(String targetType, AccessorNameSpec name2, TypeAccessibility.Inaccessible typeAccess) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Retrieves the `" + $receiver.getOriginal() + "` convention.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, typeAccess) + "\n         */\n        val " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`: Any get() =\n            " + thisConvention + ".getPluginByName<Any>(\"" + $receiver.getStringLiteral() + "\")\n\n        /**\n         * Configures the `" + $receiver.getOriginal() + "` convention.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, typeAccess) + "\n         */\n        fun " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`(configure: Any.() -> Unit): Unit =\n            configure(`" + $receiver.getStringLiteral() + "`)\n\n    ";
    }

    @NotNull
    public static final String existingTaskAccessor(@NotNull TypedAccessorSpec spec) {
        String string2;
        TypedAccessorSpec typedAccessorSpec;
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TypedAccessorSpec $receiver = typedAccessorSpec = spec;
        boolean bl = false;
        TypeAccessibility typeAccessibility = $receiver.getType();
        if (typeAccessibility instanceof TypeAccessibility.Accessible) {
            string2 = CodeGeneratorKt.accessibleExistingTaskAccessorFor($receiver.getName(), ((TypeAccessibility.Accessible)$receiver.getType()).getType().getKotlinString());
        } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
            string2 = CodeGeneratorKt.inaccessibleExistingTaskAccessorFor($receiver.getName(), (TypeAccessibility.Inaccessible)$receiver.getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String accessibleExistingTaskAccessorFor(AccessorNameSpec name2, String type2) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Provides the existing [" + $receiver.getOriginal() + "][" + type2 + "] task.\n         */\n        val TaskContainer.`" + $receiver.getKotlinIdentifier() + "`: TaskProvider<" + type2 + ">\n            get() = named<" + type2 + ">(\"" + $receiver.getStringLiteral() + "\")\n\n    ";
    }

    private static final String inaccessibleExistingTaskAccessorFor(AccessorNameSpec name2, TypeAccessibility.Inaccessible typeAccess) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Provides the existing `" + $receiver.getOriginal() + "` task.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, typeAccess) + "\n         */\n        val TaskContainer.`" + $receiver.getKotlinIdentifier() + "`: TaskProvider<Task>\n            get() = named(\"" + $receiver.getStringLiteral() + "\")\n\n    ";
    }

    @NotNull
    public static final String existingContainerElementAccessor(@NotNull TypedAccessorSpec spec) {
        String string2;
        TypedAccessorSpec typedAccessorSpec;
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TypedAccessorSpec $receiver = typedAccessorSpec = spec;
        boolean bl = false;
        TypeAccessibility typeAccessibility = $receiver.getType();
        if (typeAccessibility instanceof TypeAccessibility.Accessible) {
            string2 = CodeGeneratorKt.accessibleExistingContainerElementAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), ((TypeAccessibility.Accessible)$receiver.getType()).getType().getKotlinString());
        } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
            string2 = CodeGeneratorKt.inaccessibleExistingContainerElementAccessorFor($receiver.getReceiver().getType().getKotlinString(), $receiver.getName(), (TypeAccessibility.Inaccessible)$receiver.getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String accessibleExistingContainerElementAccessorFor(String targetType, AccessorNameSpec name2, String type2) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Provides the existing [" + $receiver.getOriginal() + "][" + type2 + "] element.\n         */\n        val " + targetType + ".`" + $receiver.getKotlinIdentifier() + "`: NamedDomainObjectProvider<" + type2 + ">\n            get() = named<" + type2 + ">(\"" + $receiver.getStringLiteral() + "\")\n\n    ";
    }

    private static final String inaccessibleExistingContainerElementAccessorFor(String containerType, AccessorNameSpec name2, TypeAccessibility.Inaccessible elementType) {
        AccessorNameSpec accessorNameSpec;
        AccessorNameSpec $receiver = accessorNameSpec = name2;
        boolean bl = false;
        return "\n        /**\n         * Provides the existing `" + $receiver.getOriginal() + "` element.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name2, elementType) + "\n         */\n        val " + containerType + ".`" + $receiver.getKotlinIdentifier() + "`: NamedDomainObjectProvider<Any>\n            get() = named(\"" + $receiver.getStringLiteral() + "\")\n\n    ";
    }

    private static final String stringLiteralFor(String original) {
        return CodeGeneratorKt.escapeStringTemplateDollarSign(original);
    }

    private static final String escapeStringTemplateDollarSign(String string2) {
        return StringsKt.replace$default((String)string2, (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
    }

    private static final AccessorNameSpec accessorNameSpec(String originalName) {
        return new AccessorNameSpec(originalName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final TypedAccessorSpec typedAccessorSpec(@NotNull ProjectSchemaEntry<? extends TypeAccessibility> schemaEntry) {
        Intrinsics.checkParameterIsNotNull(schemaEntry, (String)"schemaEntry");
        Object object = schemaEntry;
        ProjectSchemaEntry<? extends TypeAccessibility> it = object;
        boolean bl = false;
        if (!CodeGeneratorKt.isLegalAccessorName(it.getName())) return null;
        ProjectSchemaEntry<? extends TypeAccessibility> projectSchemaEntry = object;
        Object object2 = projectSchemaEntry;
        if (projectSchemaEntry == null) return null;
        TypeAccessibility typeAccessibility = ((ProjectSchemaEntry)object2).getTarget();
        object2 = typeAccessibility;
        if (typeAccessibility == null) return null;
        Object $receiver = object = object2;
        boolean bl2 = false;
        Object object3 = $receiver;
        if (!(object3 instanceof TypeAccessibility.Accessible)) {
            if (!(object3 instanceof TypeAccessibility.Inaccessible)) throw new NoWhenBranchMatchedException();
            return null;
        }
        TypedAccessorSpec typedAccessorSpec = new TypedAccessorSpec((TypeAccessibility.Accessible)$receiver, CodeGeneratorKt.accessorNameSpec(schemaEntry.getName()), schemaEntry.getType());
        return typedAccessorSpec;
    }

    private static final String documentInaccessibilityReasons(AccessorNameSpec name2, TypeAccessibility.Inaccessible typeAccess) {
        return '`' + name2.getKotlinIdentifier() + "` is not accessible in a type safe way because:\n" + CollectionsKt.joinToString$default((Iterable)typeAccess.getReasons(), (CharSequence)"\n", null, null, (int)0, null, (Function1)documentInaccessibilityReasons.1.INSTANCE, (int)30, null);
    }

    public static final boolean isLegalAccessorName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return CodeGeneratorKt.isKotlinIdentifier('`' + name2 + '`') && StringsKt.indexOfAny$default((CharSequence)name2, (char[])invalidNameChars, (int)0, (boolean)false, (int)6, null) < 0;
    }

    private static final boolean isKotlinIdentifier(String candidate) {
        KotlinLexer kotlinLexer;
        KotlinLexer $receiver = kotlinLexer = new KotlinLexer();
        boolean bl = false;
        $receiver.start((CharSequence)candidate);
        return $receiver.getTokenStart() == 0 && $receiver.getTokenEnd() == candidate.length() && Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.IDENTIFIER);
    }

    public static final /* synthetic */ String access$stringLiteralFor(String original) {
        return CodeGeneratorKt.stringLiteralFor(original);
    }
}

