/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;

class IncrementalCompilationInitializer {
    private final FileOperations fileOperations;
    private final FileTree sourceTree;

    public IncrementalCompilationInitializer(FileOperations fileOperations, FileTree sourceTree) {
        this.fileOperations = fileOperations;
        this.sourceTree = sourceTree;
    }

    public void initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable)ImmutableSet.of());
            spec.setClasses(Collections.<String>emptySet());
            return;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet sourceToCompile = (PatternSet)patternSetFactory.create();
        this.prepareJavaPatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
        this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getHeaderOutputDirectory());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = IncrementalCompilationInitializer.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), (Factory<PatternSet>)patternSetFactory);
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), spec.getDestinationDir());
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), (Object)spec.getDestinationDir()));
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), spec.getCompileOptions().getHeaderOutputDirectory());
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching((PatternFilterable)sourceToCompile);
    }

    private void includePreviousCompilationOutputOnClasspath(JavaCompileSpec spec) {
        ArrayList classpath = Lists.newArrayList((Iterable)spec.getCompileClasspath());
        File destinationDir = spec.getDestinationDir();
        classpath.add(destinationDir);
        spec.setCompileClasspath(classpath);
    }

    private void addClassesToProcess(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        HashSet classesToProcess = Sets.newHashSet(recompilationSpec.getClassesToProcess());
        classesToProcess.removeAll(recompilationSpec.getClassesToCompile());
        spec.setClasses(classesToProcess);
    }

    private void deleteStaleFilesIn(PatternSet filesToDelete, File destinationDir) {
        if (filesToDelete == null || filesToDelete.isEmpty() || destinationDir == null) {
            return;
        }
        Set toDelete = this.fileOperations.fileTree((Object)destinationDir).matching((PatternFilterable)filesToDelete).getFiles();
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(toDelete);
        cleaner.addDirToClean(destinationDir);
        cleaner.execute();
    }

    private void prepareJavaPatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            filesToDelete.include(new String[]{path.concat(".class")});
            filesToDelete.include(new String[]{path.concat(".java")});
            filesToDelete.include(new String[]{path.concat(".h")});
            filesToDelete.include(new String[]{path.concat("$*.class")});
            filesToDelete.include(new String[]{path.concat("$*.java")});
            filesToDelete.include(new String[]{path.concat("$*.h")});
            sourceToCompile.include(new String[]{path.concat(".java")});
            sourceToCompile.include(new String[]{path.concat("$*.java")});
        }
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, Factory<PatternSet> patternSetFactory) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, (PatternSet)patternSetFactory.create());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(new String[]{resource.getPath()});
        }
        return resourcesByLocation;
    }
}

