/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Transformers;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifacts;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentArtifactsResolveResult;

class RepositoryChainArtifactResolver
implements ArtifactResolver,
OriginArtifactSelector {
    private final Map<String, ModuleComponentRepository> repositories = new LinkedHashMap<String, ModuleComponentRepository>();

    RepositoryChainArtifactResolver() {
    }

    void add(ModuleComponentRepository repository) {
        this.repositories.put(repository.getId(), repository);
    }

    @Override
    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSource());
        ComponentResolveMetadata unpackedComponent = this.unpackSource(component);
        sourceRepository.getLocalAccess().resolveArtifactsWithType(unpackedComponent, artifactType, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifactsWithType(unpackedComponent, artifactType, result);
        }
    }

    @Override
    @Nullable
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, ConfigurationMetadata configuration, ArtifactTypeRegistry artifactTypeRegistry, ModuleExclusion exclusions, ImmutableAttributes overriddenAttributes) {
        String value;
        AttributeValue componentTypeEntry;
        if (component.getSource() == null) {
            return ArtifactSet.NO_ARTIFACTS;
        }
        if (configuration.getArtifacts().isEmpty() && (componentTypeEntry = configuration.getAttributes().findEntry(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE)).isPresent() && ("platform".equals(value = (String)componentTypeEntry.get()) || "enforced-platform".equals(value))) {
            return ArtifactSet.NO_ARTIFACTS;
        }
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSource());
        ComponentResolveMetadata unpackedComponent = this.unpackSource(component);
        DefaultBuildableComponentArtifactsResolveResult result = new DefaultBuildableComponentArtifactsResolveResult();
        sourceRepository.getLocalAccess().resolveArtifacts(unpackedComponent, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifacts(unpackedComponent, result);
        }
        if (result.hasResult()) {
            return ((ComponentArtifacts)result.getResult()).getArtifactsFor(component, configuration, this, sourceRepository.getArtifactCache(), artifactTypeRegistry, exclusions, overriddenAttributes);
        }
        return null;
    }

    @Override
    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource source, BuildableArtifactResolveResult result) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(source);
        ModuleSource unpackedSource = this.unpackSource(source);
        sourceRepository.getLocalAccess().resolveArtifact(artifact, unpackedSource, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifact(artifact, unpackedSource, result);
        }
    }

    private ModuleComponentRepository findSourceRepository(ModuleSource originalSource) {
        ModuleComponentRepository moduleVersionRepository = this.repositories.get(this.repositorySource(originalSource).getRepositoryId());
        if (moduleVersionRepository == null) {
            throw new IllegalStateException("Attempting to resolve artifacts from invalid repository");
        }
        return moduleVersionRepository;
    }

    private RepositoryChainModuleSource repositorySource(ModuleSource original) {
        return (RepositoryChainModuleSource)Transformers.cast(RepositoryChainModuleSource.class).transform((Object)original);
    }

    private ModuleSource unpackSource(ModuleSource original) {
        return this.repositorySource(original).getDelegate();
    }

    private ComponentResolveMetadata unpackSource(ComponentResolveMetadata component) {
        return component.withSource(this.repositorySource(component.getSource()).getDelegate());
    }
}

