/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;

public class JvmPluginsHelper {
    private static void registerClassesDirVariant(final SourceSet sourceSet, ObjectFactory objectFactory, Configuration configuration) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("classes");
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "classes")));
        variant.artifactsProvider((Factory)new Factory<List<PublishArtifact>>(){

            @Nullable
            public List<PublishArtifact> create() {
                Set classesDirs = sourceSet.getOutput().getClassesDirs().getFiles();
                DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
                TaskDependency compileDependencies = output.getCompileDependencies();
                ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)classesDirs.size());
                for (final File classesDir : classesDirs) {
                    artifacts.add((Object)new IntermediateJavaArtifact("java-classes-directory", compileDependencies){

                        public File getFile() {
                            return classesDir;
                        }
                    });
                }
                return artifacts.build();
            }
        });
    }

    public static void addApiToSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileConfiguration = configurations.getByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
    }

    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        JvmPluginsHelper.configureForSourceSet(sourceSet, sourceDirectorySet, compile, target);
        JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, options, target);
    }

    private static void configureForSourceSet(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, AbstractCompile compile, final Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource((FileTree)sourceSet.getJava());
        final ConfigurableFileCollection classpath = compile.getProject().getObjects().fileCollection();
        classpath.from(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getCompileClasspath().plus((FileCollection)target.files(new Object[]{sourceSet.getJava().getOutputDir()}));
            }
        }});
        compile.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return classpath;
            }
        });
        compile.setDestinationDir(target.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return sourceDirectorySet.getOutputDir();
            }
        }));
    }

    public static void configureAnnotationProcessorPath(final SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, CompileOptions options, final Project target) {
        ConventionMapping conventionMapping = new DslObject((Object)options).getConventionMapping();
        conventionMapping.map("annotationProcessorPath", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getAnnotationProcessorPath();
            }
        });
        final String annotationProcessorGeneratedSourcesChildPath = "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        conventionMapping.map("annotationProcessorGeneratedSourcesDirectory", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return new File(target.getBuildDir(), annotationProcessorGeneratedSourcesChildPath);
            }
        });
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, final Project target, Provider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        final String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.setOutputDir(target.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return new File(target.getBuildDir(), sourceSetChildPath);
            }
        }));
        DefaultSourceSetOutput sourceSetOutput = (DefaultSourceSetOutput)Cast.cast(DefaultSourceSetOutput.class, (Object)sourceSet.getOutput());
        sourceSetOutput.addClassesDir(new Callable<File>(){

            @Override
            public File call() {
                return sourceDirectorySet.getOutputDir();
            }
        });
        sourceSetOutput.registerCompileTask(compileTask);
        sourceSetOutput.getGeneratedSourcesDirs().from(new Object[]{options.map((Transformer)new Transformer<Object, CompileOptions>(){

            public Object transform(CompileOptions compileOptions) {
                return compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
            }
        })}).builtBy(new Object[]{compileTask});
    }

    public static void configureClassesDirectoryVariant(final SourceSet sourceSet, final Project target, final String targetConfigName, String usage) {
        target.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(Configuration config) {
                if (targetConfigName.equals(config.getName())) {
                    JvmPluginsHelper.registerClassesDirVariant(sourceSet, target.getObjects(), config);
                }
            }
        });
    }

    public static abstract class IntermediateJavaArtifact
    extends AbstractPublishArtifact {
        private final String type;

        public IntermediateJavaArtifact(String type, Object task) {
            super(new Object[]{task});
            this.type = type;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }
    }
}

