/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.InputChangeAction;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaConventionalSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ResourceChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class JavaRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private final IncrementalTaskInputs inputs;
    private final JavaConventionalSourceFileClassNameConverter sourceFileClassNameConverter;

    public JavaRecompilationSpecProvider(FileOperations fileOperations, FileTreeInternal sources, IncrementalTaskInputs inputs, CompilationSourceDirs sourceDirs) {
        super(fileOperations, (FileTree)sources);
        this.sourceFileClassNameConverter = new JavaConventionalSourceFileClassNameConverter(sourceDirs);
        this.inputs = inputs;
    }

    @Override
    public boolean isIncremental() {
        return this.inputs.isIncremental();
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec);
        spec.getClassesToProcess().addAll(previous.getTypesToReprocess());
        return spec;
    }

    @Override
    public void initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable)ImmutableSet.of());
            spec.setClasses(Collections.emptySet());
            return;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet sourceToCompile = (PatternSet)patternSetFactory.create();
        this.prepareJavaPatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
        this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getHeaderOutputDirectory());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = JavaRecompilationSpecProvider.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), (Factory<PatternSet>)patternSetFactory);
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), spec.getDestinationDir());
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), (Object)spec.getDestinationDir()));
        this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), spec.getCompileOptions().getHeaderOutputDirectory());
    }

    @Override
    public WorkResult decorateResult(RecompilationSpec recompilationSpec, WorkResult workResult) {
        return workResult;
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching((PatternFilterable)sourceToCompile);
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, Factory<PatternSet> patternSetFactory) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, (PatternSet)patternSetFactory.create());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(new String[]{resource.getPath()});
        }
        return resourcesByLocation;
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        SourceFileChangeProcessor javaChangeProcessor = new SourceFileChangeProcessor(previous);
        AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor = new AnnotationProcessorChangeProcessor(current, previous);
        ResourceChangeProcessor resourceChangeProcessor = new ResourceChangeProcessor(current.getAnnotationProcessorPath());
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, annotationProcessorChangeProcessor, resourceChangeProcessor, this.sourceFileClassNameConverter);
        this.inputs.outOfDate((Action)action);
        this.inputs.removed((Action)action);
    }

    private void prepareJavaPatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            filesToDelete.include(new String[]{path.concat(".class")});
            filesToDelete.include(new String[]{path.concat(".java")});
            filesToDelete.include(new String[]{path.concat(".h")});
            filesToDelete.include(new String[]{path.concat("$*.class")});
            filesToDelete.include(new String[]{path.concat("$*.java")});
            filesToDelete.include(new String[]{path.concat("$*.h")});
            sourceToCompile.include(new String[]{path.concat(".java")});
            sourceToCompile.include(new String[]{path.concat("$*.java")});
        }
    }
}

