/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Factory;

public class IdentityFileResolver
extends AbstractFileResolver {
    public IdentityFileResolver() {
        this((Factory<PatternSet>)PatternSets.getNonCachingPatternSetFactory());
    }

    public IdentityFileResolver(Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
    }

    @Override
    protected File doResolve(Object path) {
        File file = this.convertObjectToFile(path);
        if (file == null) {
            throw new IllegalArgumentException(String.format("Cannot convert path to File. path='%s'", path));
        }
        if (!file.isAbsolute()) {
            throw new UnsupportedOperationException(String.format("Cannot convert relative path %s to an absolute file.", path));
        }
        return file;
    }

    public String resolveAsRelativePath(Object path) {
        throw new UnsupportedOperationException(String.format("Cannot convert path %s to a relative path.", path));
    }

    public boolean canResolveRelativePath() {
        return false;
    }
}

