/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.file.RelativePath;

public class CoffeeScriptCompileDestinationCalculator
implements Transformer<File, RelativePath> {
    private final File destination;

    public CoffeeScriptCompileDestinationCalculator(File destination) {
        this.destination = destination;
    }

    public File transform(RelativePath relativePath) {
        String sourceFileName;
        String destinationFileNameBase = sourceFileName = relativePath.getLastName();
        if (sourceFileName.endsWith(".coffee")) {
            destinationFileNameBase = sourceFileName.substring(0, sourceFileName.length() - 7);
        }
        String destinationFileName = destinationFileNameBase + ".js";
        RelativePath destinationRelativePath = relativePath.replaceLastName(destinationFileName);
        return new File(this.destination, destinationRelativePath.getPathString());
    }

    public static Transformer<Transformer<File, RelativePath>, File> asFactory() {
        return new Transformer<Transformer<File, RelativePath>, File>(){

            public Transformer<File, RelativePath> transform(File original) {
                return new CoffeeScriptCompileDestinationCalculator(original);
            }
        };
    }
}

