/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.assembler.plugins.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.assembler.tasks.Assemble;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.platform.base.BinarySpec;

public class AssembleTaskConfig
implements SourceTransformTaskConfig {
    public String getTaskPrefix() {
        return "assemble";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return Assemble.class;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
        this.configureAssembleTask((Assemble)task, (NativeBinarySpecInternal)binary, (LanguageSourceSetInternal)sourceSet);
    }

    private void configureAssembleTask(Assemble task, final NativeBinarySpecInternal binary, LanguageSourceSetInternal sourceSet) {
        task.setDescription("Assembles the " + sourceSet + " of " + binary);
        task.getToolChain().set((Object)binary.getToolChain());
        task.getTargetPlatform().set((Object)binary.getTargetPlatform());
        task.source(sourceSet.getSource());
        FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)((ProjectInternal)task.getProject()).getServices().get(FileCollectionFactory.class);
        task.includes(fileCollectionFactory.create(new MinimalFileSet(){

            public Set<File> getFiles() {
                PlatformToolProvider platformToolProvider = ((NativeToolChainInternal)binary.getToolChain()).select((NativePlatformInternal)binary.getTargetPlatform());
                return new LinkedHashSet<File>(platformToolProvider.getSystemLibraries(ToolType.ASSEMBLER).getIncludeDirs());
            }

            public String getDisplayName() {
                return "System includes for " + binary.getToolChain().getDisplayName();
            }
        }));
        Project project = task.getProject();
        task.setObjectFileDir(new File(binary.getNamingScheme().getOutputDirectory(project.getBuildDir(), "objs"), sourceSet.getProjectScopedName()));
        Tool assemblerTool = binary.getToolByName("assembler");
        task.setAssemblerArgs(assemblerTool.getArgs());
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

