/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.function.Consumer;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginMetadataFactory.class);
    private static final String BUILD_INVOCATION_ID_KEY = "buildInvocationId";
    private static final String TYPE_KEY = "type";
    private static final String IDENTITY_KEY = "identity";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String EXECUTION_TIME_KEY = "executionTime";
    private static final String ROOT_PATH_KEY = "rootPath";
    private static final String OPERATING_SYSTEM_KEY = "operatingSystem";
    private static final String HOST_NAME_KEY = "hostName";
    private static final String USER_NAME_KEY = "userName";
    private final String userName;
    private final String operatingSystem;
    private final String currentBuildInvocationId;
    private final Consumer<Properties> additionalProperties;
    private final File rootDir;
    private volatile String localHostName;

    public OriginMetadataFactory(File rootDir, String userName, String operatingSystem, String currentBuildInvocationId, Consumer<Properties> additionalProperties) {
        this.rootDir = rootDir;
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.additionalProperties = additionalProperties;
        this.currentBuildInvocationId = currentBuildInvocationId;
    }

    public OriginWriter createWriter(final CacheableEntity entry, final long elapsedTime) {
        return new OriginWriter(){

            @Override
            public void execute(OutputStream outputStream) throws IOException {
                Properties properties = new Properties();
                properties.setProperty(OriginMetadataFactory.BUILD_INVOCATION_ID_KEY, OriginMetadataFactory.this.currentBuildInvocationId);
                properties.setProperty(OriginMetadataFactory.TYPE_KEY, entry.getClass().getCanonicalName());
                properties.setProperty(OriginMetadataFactory.IDENTITY_KEY, entry.getIdentity());
                properties.setProperty(OriginMetadataFactory.CREATION_TIME_KEY, Long.toString(System.currentTimeMillis()));
                properties.setProperty(OriginMetadataFactory.EXECUTION_TIME_KEY, Long.toString(elapsedTime));
                properties.setProperty(OriginMetadataFactory.ROOT_PATH_KEY, OriginMetadataFactory.this.rootDir.getAbsolutePath());
                properties.setProperty(OriginMetadataFactory.OPERATING_SYSTEM_KEY, OriginMetadataFactory.this.operatingSystem);
                properties.setProperty(OriginMetadataFactory.HOST_NAME_KEY, OriginMetadataFactory.this.determineHostName());
                properties.setProperty(OriginMetadataFactory.USER_NAME_KEY, OriginMetadataFactory.this.userName);
                OriginMetadataFactory.this.additionalProperties.accept(properties);
                properties.store(outputStream, "Generated origin information");
            }
        };
    }

    private String determineHostName() {
        if (this.localHostName == null) {
            try {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.localHostName = "<unknown>";
            }
        }
        return this.localHostName;
    }

    public OriginReader createReader(final CacheableEntity entry) {
        return new OriginReader(){

            @Override
            public OriginMetadata execute(InputStream inputStream) throws IOException {
                Properties properties = new Properties();
                properties.load(inputStream);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Origin for {}: {}", (Object)entry.getDisplayName(), (Object)properties);
                }
                String originBuildInvocationId = properties.getProperty(OriginMetadataFactory.BUILD_INVOCATION_ID_KEY);
                String executionTimeAsString = properties.getProperty(OriginMetadataFactory.EXECUTION_TIME_KEY);
                if (originBuildInvocationId == null || executionTimeAsString == null) {
                    throw new IllegalStateException("Cached result format error, corrupted origin metadata.");
                }
                long originalExecutionTime = Long.parseLong(executionTimeAsString);
                return new OriginMetadata(originBuildInvocationId, originalExecutionTime);
            }
        };
    }
}

