/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class TemporaryVariable {
    @Nullable
    private final JsExpression assignmentExpression;
    @NotNull
    private final JsName variableName;
    @Nullable
    private final KotlinType type;

    static TemporaryVariable create(@NotNull JsName temporaryName, @Nullable JsExpression initExpression) {
        if (temporaryName == null) {
            TemporaryVariable.$$$reportNull$$$1(0);
        }
        if (temporaryName == null) {
            TemporaryVariable.$$$reportNull$$$0(0);
        }
        JsBinaryOperation rhs = null;
        KotlinType type2 = null;
        if (initExpression != null) {
            rhs = JsAstUtils.assignment(temporaryName.makeRef(), initExpression);
            rhs.source(initExpression.getSource());
            MetadataProperties.setSynthetic(rhs, true);
            type2 = MetadataProperties.getType(initExpression);
        }
        return new TemporaryVariable(temporaryName, rhs, type2);
    }

    protected TemporaryVariable(@NotNull JsName temporaryName, @Nullable JsExpression assignmentExpression, @Nullable KotlinType type2) {
        if (temporaryName == null) {
            TemporaryVariable.$$$reportNull$$$1(1);
        }
        if (temporaryName == null) {
            TemporaryVariable.$$$reportNull$$$0(1);
        }
        this.variableName = temporaryName;
        this.assignmentExpression = assignmentExpression;
        this.type = type2;
    }

    @NotNull
    public JsNameRef reference() {
        JsNameRef result2 = this.variableName.makeRef();
        MetadataProperties.setSynthetic(result2, true);
        MetadataProperties.setType(result2, this.type);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            TemporaryVariable.$$$reportNull$$$0(2);
        }
        if (jsNameRef == null) {
            TemporaryVariable.$$$reportNull$$$1(2);
        }
        return jsNameRef;
    }

    @NotNull
    public JsName name() {
        JsName jsName = this.variableName;
        if (jsName == null) {
            TemporaryVariable.$$$reportNull$$$0(3);
        }
        if (jsName == null) {
            TemporaryVariable.$$$reportNull$$$1(3);
        }
        return jsName;
    }

    @NotNull
    public JsExpression assignmentExpression() {
        assert (this.assignmentExpression != null);
        JsExpression jsExpression = this.assignmentExpression;
        if (jsExpression == null) {
            TemporaryVariable.$$$reportNull$$$0(4);
        }
        if (jsExpression == null) {
            TemporaryVariable.$$$reportNull$$$1(4);
        }
        return jsExpression;
    }

    @NotNull
    public JsStatement assignmentStatement() {
        JsStatement jsStatement = JsAstUtils.asSyntheticStatement(this.assignmentExpression());
        if (jsStatement == null) {
            TemporaryVariable.$$$reportNull$$$0(5);
        }
        if (jsStatement == null) {
            TemporaryVariable.$$$reportNull$$$1(5);
        }
        return jsStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/TemporaryVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/TemporaryVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/TemporaryVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/TemporaryVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

