/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.pgp;

import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRing;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryFactory;
import org.gradle.util.ConfigureUtil;

public class InMemoryPgpSignatoryProvider
implements SignatoryProvider<PgpSignatory> {
    private final PgpSignatoryFactory factory = new PgpSignatoryFactory();
    private final Map<String, PgpSignatory> signatories = new LinkedHashMap<String, PgpSignatory>();
    private final String defaultSecretKey;
    private final String defaultPassword;

    public InMemoryPgpSignatoryProvider(String defaultSecretKey, String defaultPassword) {
        this.defaultSecretKey = defaultSecretKey;
        this.defaultPassword = defaultPassword;
    }

    @Override
    public PgpSignatory getDefaultSignatory(Project project) {
        if (this.defaultSecretKey != null && this.defaultPassword != null) {
            return this.createSignatory("default", this.defaultSecretKey, this.defaultPassword);
        }
        return null;
    }

    @Override
    public PgpSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    public PgpSignatory propertyMissing(String signatoryName) {
        return this.getSignatory(signatoryName);
    }

    @Override
    public void configure(SigningExtension settings, Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)new Object(){

            public void methodMissing(String name, Object args) {
                InMemoryPgpSignatoryProvider.this.createSignatoryFor(name, (Object[])DefaultGroovyMethods.asType((Object)args, Object[].class));
            }
        });
    }

    private void createSignatoryFor(String name, Object[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Invalid args (" + name + ": " + Arrays.toString(args) + ")");
        }
        String secretKey = args[0].toString();
        String password = args[1].toString();
        this.signatories.put(name, this.createSignatory(name, secretKey, password));
    }

    private PgpSignatory createSignatory(String name, String secretKey, String password) {
        PgpSignatory pgpSignatory;
        block8: {
            InputStream in = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(secretKey.getBytes(StandardCharsets.UTF_8)));
            try {
                PGPSecretKey key = new JcaPGPSecretKeyRing(in).getSecretKey();
                pgpSignatory = this.factory.createSignatory(name, key, password);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InvalidUserDataException("Could not read PGP secret key", (Throwable)e);
                }
            }
            in.close();
        }
        return pgpSignatory;
    }
}

