/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientServices;
import org.gradle.launcher.daemon.client.SingleUseDaemonClientServices;
import org.gradle.launcher.daemon.configuration.DaemonParameters;

public class DaemonClientFactory {
    private final ServiceRegistry sharedServices;

    public DaemonClientFactory(ServiceRegistry sharedServices) {
        this.sharedServices = sharedServices;
    }

    public ServiceRegistry createBuildClientServices(OutputEventListener loggingReceiver, DaemonParameters daemonParameters, InputStream stdin) {
        DefaultServiceRegistry loggingServices = new DefaultServiceRegistry(this.sharedServices);
        loggingServices.add(OutputEventListener.class, loggingReceiver);
        return new DaemonClientServices((ServiceRegistry)loggingServices, daemonParameters, stdin);
    }

    public ServiceRegistry createSingleUseDaemonClientServices(OutputEventListener loggingReceiver, DaemonParameters daemonParameters, InputStream stdin) {
        DefaultServiceRegistry loggingServices = new DefaultServiceRegistry(this.sharedServices);
        loggingServices.add(OutputEventListener.class, loggingReceiver);
        return new SingleUseDaemonClientServices((ServiceRegistry)loggingServices, daemonParameters, stdin);
    }

    public ServiceRegistry createStopDaemonServices(OutputEventListener loggingReceiver, DaemonParameters daemonParameters) {
        DefaultServiceRegistry loggingServices = new DefaultServiceRegistry(this.sharedServices);
        loggingServices.add(OutputEventListener.class, loggingReceiver);
        return new DaemonClientServices((ServiceRegistry)loggingServices, daemonParameters, new ByteArrayInputStream(new byte[0]));
    }
}

