/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.Map;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DependencyResultSerializer {
    private static final byte SUCCESSFUL = 0;
    private static final byte FAILED = 1;
    private final ComponentSelectionReasonSerializer componentSelectionReasonSerializer = new ComponentSelectionReasonSerializer();
    private final ResolvedVariantResultSerializer resolvedVariantResultSerializer;

    public DependencyResultSerializer(ResolvedVariantResultSerializer resolvedVariantResultSerializer) {
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
    }

    public ResolvedGraphDependency read(Decoder decoder, Map<Long, ComponentSelector> selectors, Map<ComponentSelector, ModuleVersionResolveException> failures) throws IOException {
        Long selectorId = decoder.readSmallLong();
        ComponentSelector requested = selectors.get(selectorId);
        boolean constraint = decoder.readBoolean();
        ResolvedVariantResult fromVariant = this.resolvedVariantResultSerializer.read(decoder);
        byte resultByte = decoder.readByte();
        if (resultByte == 0) {
            Long selectedId = decoder.readSmallLong();
            return new DetachedResolvedGraphDependency(requested, selectedId, null, null, constraint, fromVariant, this.resolvedVariantResultSerializer.read(decoder));
        }
        if (resultByte == 1) {
            ComponentSelectionReason reason = this.componentSelectionReasonSerializer.read(decoder);
            ModuleVersionResolveException failure = failures.get(requested);
            return new DetachedResolvedGraphDependency(requested, null, reason, failure, constraint, fromVariant, null);
        }
        throw new IllegalArgumentException("Unknown result type: " + resultByte);
    }

    public void write(Encoder encoder, DependencyGraphEdge value) throws IOException {
        encoder.writeSmallLong(value.getSelector().getResultId().longValue());
        encoder.writeBoolean(value.isConstraint());
        this.resolvedVariantResultSerializer.write(encoder, value.getFromVariant());
        if (value.getFailure() == null) {
            encoder.writeByte((byte)0);
            encoder.writeSmallLong(value.getSelected().longValue());
            this.resolvedVariantResultSerializer.write(encoder, value.getSelectedVariant());
        } else {
            encoder.writeByte((byte)1);
            this.componentSelectionReasonSerializer.write(encoder, value.getReason());
        }
    }
}

