/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GUtil;

public class ArchivePublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private File file;
    private AbstractArchiveTask archiveTask;

    public ArchivePublishArtifact(AbstractArchiveTask archiveTask) {
        super(archiveTask);
        this.archiveTask = archiveTask;
    }

    @Override
    public ArchivePublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String baseName = (String)this.archiveTask.getArchiveBaseName().getOrNull();
        if (baseName != null) {
            return this.withAppendix(baseName);
        }
        return (String)this.archiveTask.getArchiveAppendix().getOrNull();
    }

    private String withAppendix(String baseName) {
        String appendix = (String)this.archiveTask.getArchiveAppendix().getOrNull();
        return baseName + (GUtil.isTrue((Object)appendix) ? "-" + appendix : "");
    }

    public String getExtension() {
        return (String)GUtil.elvis((Object)this.extension, (Object)((String)this.archiveTask.getArchiveExtension().getOrNull()));
    }

    public String getType() {
        return (String)GUtil.elvis((Object)this.type, (Object)((String)this.archiveTask.getArchiveExtension().getOrNull()));
    }

    public String getClassifier() {
        return (String)GUtil.elvis((Object)this.classifier, (Object)((String)this.archiveTask.getArchiveClassifier().getOrNull()));
    }

    public File getFile() {
        return (File)GUtil.elvis((Object)this.file, (Object)((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile());
    }

    public Date getDate() {
        return (Date)GUtil.elvis((Object)this.date, (Object)new Date(((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile().lastModified()));
    }

    public AbstractArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

