/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.resource.ResourceExceptions;

public class FileCollectionBackedTextResource
implements TextResourceInternal {
    private final TemporaryFileProvider tempFileProvider;
    private final FileCollection fileCollection;
    private final Charset charset;

    public FileCollectionBackedTextResource(TemporaryFileProvider tempFileProvider, FileCollection fileCollection, Charset charset) {
        this.tempFileProvider = tempFileProvider;
        this.fileCollection = fileCollection;
        this.charset = charset;
    }

    @Override
    public String getDisplayName() {
        return this.fileCollection.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String asString() {
        File file = this.asFile();
        try {
            return Files.toString((File)file, (Charset)this.charset);
        }
        catch (FileNotFoundException e) {
            throw ResourceExceptions.readMissing((File)file, (Throwable)e);
        }
        catch (IOException e) {
            throw ResourceExceptions.readFailed((File)file, (Throwable)e);
        }
    }

    public Reader asReader() {
        File file = this.asFile();
        try {
            return Files.newReader((File)this.asFile(), (Charset)this.charset);
        }
        catch (FileNotFoundException e) {
            throw ResourceExceptions.readMissing((File)file, (Throwable)e);
        }
    }

    public File asFile(String targetCharset) {
        try {
            Charset targetCharsetObj = Charset.forName(targetCharset);
            if (targetCharsetObj.equals(this.charset)) {
                return this.fileCollection.getSingleFile();
            }
            File targetFile = this.tempFileProvider.createTemporaryFile("fileCollection", ".txt", "resource");
            try {
                Files.asCharSource((File)this.fileCollection.getSingleFile(), (Charset)this.charset).copyTo(Files.asCharSink((File)targetFile, (Charset)targetCharsetObj, (FileWriteMode[])new FileWriteMode[0]));
            }
            catch (IOException e) {
                throw new ResourceException("Could not write " + this.getDisplayName() + " content to " + targetFile + ".", (Throwable)e);
            }
            return targetFile;
        }
        catch (Exception e) {
            throw ResourceExceptions.readFailed((String)this.getDisplayName(), (Throwable)e);
        }
    }

    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    public TaskDependency getBuildDependencies() {
        return this.fileCollection.getBuildDependencies();
    }

    public Object getInputProperties() {
        return this.charset.name();
    }

    public FileCollection getInputFiles() {
        return this.fileCollection;
    }
}

