/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InstantExecution;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.DeprecatedUsageBuildOperationProgressBroadaster;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.service.scopes.CrossBuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.time.Time;
import org.gradle.invocation.DefaultGradle;
import org.gradle.util.DeprecationLogger;

public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionScopeServices crossBuildSessionScopeServices;
    private DefaultGradleLauncher rootBuild;

    public DefaultGradleLauncherFactory(GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionScopeServices crossBuildSessionScopeServices) {
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionScopeServices = crossBuildSessionScopeServices;
    }

    @Override
    public GradleLauncher newInstance(BuildDefinition buildDefinition, RootBuildState build, BuildTreeScopeServices parentRegistry) {
        DefaultGradleLauncher launcher;
        if (this.rootBuild != null) {
            throw new IllegalStateException("Cannot have a current root build");
        }
        this.rootBuild = launcher = this.doNewInstance(buildDefinition, build, null, parentRegistry, (List<?>)ImmutableList.of((Object)new Stoppable(){

            public void stop() {
                DefaultGradleLauncherFactory.this.rootBuild = null;
            }
        }));
        final DefaultDeploymentRegistry deploymentRegistry = (DefaultDeploymentRegistry)parentRegistry.get(DefaultDeploymentRegistry.class);
        launcher.getGradle().addBuildListener((BuildListener)new InternalBuildAdapter(){

            public void buildFinished(BuildResult result) {
                deploymentRegistry.buildFinished(result);
            }
        });
        return launcher;
    }

    private DefaultGradleLauncher doNewInstance(BuildDefinition buildDefinition, BuildState build, @Nullable GradleLauncher parent, BuildTreeScopeServices buildTreeScopeServices, List<?> servicesToStop) {
        BuildScopeServices serviceRegistry = new BuildScopeServices((ServiceRegistry)buildTreeScopeServices);
        serviceRegistry.add(BuildDefinition.class, buildDefinition);
        serviceRegistry.add(BuildState.class, build);
        NestedBuildFactoryImpl nestedBuildFactory = new NestedBuildFactoryImpl(buildTreeScopeServices);
        serviceRegistry.add(NestedBuildFactory.class, nestedBuildFactory);
        ListenerManager listenerManager = (ListenerManager)serviceRegistry.get(ListenerManager.class);
        for (Action action : serviceRegistry.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute((Object)listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener((Object)usageLocationReporter);
        StartParameter startParameter = buildDefinition.getStartParameter();
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)false);
            }
        }
        DeprecatedUsageBuildOperationProgressBroadaster deprecationWarningBuildOperationProgressBroadaster = (DeprecatedUsageBuildOperationProgressBroadaster)serviceRegistry.get(DeprecatedUsageBuildOperationProgressBroadaster.class);
        DeprecationLogger.init((UsageLocationReporter)usageLocationReporter, (WarningMode)startParameter.getWarningMode(), (DeprecatedUsageBuildOperationProgressBroadaster)deprecationWarningBuildOperationProgressBroadaster);
        GradleInternal parentBuild = parent == null ? null : parent.getGradle();
        SettingsPreparer settingsPreparer = (SettingsPreparer)serviceRegistry.get(SettingsPreparer.class);
        GradleInternal gradle = (GradleInternal)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultGradle.class, new Object[]{parentBuild, startParameter, serviceRegistry.get(ServiceRegistryFactory.class)});
        IncludedBuildControllers includedBuildControllers = (IncludedBuildControllers)gradle.getServices().get(IncludedBuildControllers.class);
        TaskExecutionPreparer taskExecutionPreparer = (TaskExecutionPreparer)gradle.getServices().get(TaskExecutionPreparer.class);
        DefaultGradleLauncher gradleLauncher = new DefaultGradleLauncher(gradle, (ProjectsPreparer)serviceRegistry.get(ProjectsPreparer.class), (ExceptionAnalyser)serviceRegistry.get(ExceptionAnalyser.class), gradle.getBuildListenerBroadcaster(), (BuildCompletionListener)listenerManager.getBroadcaster(BuildCompletionListener.class), (BuildWorkExecutor)gradle.getServices().get(BuildWorkExecutor.class), serviceRegistry, servicesToStop, includedBuildControllers, settingsPreparer, taskExecutionPreparer, (InstantExecution)gradle.getServices().get(InstantExecution.class), (BuildSourceBuilder)gradle.getServices().get(BuildSourceBuilder.class));
        nestedBuildFactory.setParent(gradleLauncher);
        nestedBuildFactory.setBuildCancellationToken((BuildCancellationToken)buildTreeScopeServices.get(BuildCancellationToken.class));
        return gradleLauncher;
    }

    private class NestedBuildFactoryImpl
    implements NestedBuildFactory {
        private final BuildTreeScopeServices buildTreeScopeServices;
        private DefaultGradleLauncher parent;
        private BuildCancellationToken buildCancellationToken;

        NestedBuildFactoryImpl(BuildTreeScopeServices buildTreeScopeServices) {
            this.buildTreeScopeServices = buildTreeScopeServices;
        }

        @Override
        public GradleLauncher nestedInstance(BuildDefinition buildDefinition, NestedBuildState build) {
            return DefaultGradleLauncherFactory.this.doNewInstance(buildDefinition, build, this.parent, this.buildTreeScopeServices, (List)ImmutableList.of());
        }

        @Override
        public GradleLauncher nestedBuildTree(BuildDefinition buildDefinition, NestedRootBuild build) {
            StartParameter startParameter = buildDefinition.getStartParameter();
            final ServiceRegistry userHomeServices = DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.getServicesFor(startParameter.getGradleUserHomeDir());
            DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
            BuildSessionScopeServices sessionScopeServices = new BuildSessionScopeServices(userHomeServices, DefaultGradleLauncherFactory.this.crossBuildSessionScopeServices, startParameter, buildRequestMetaData, ClassPath.EMPTY, this.buildCancellationToken, buildRequestMetaData.getClient(), new NoOpBuildEventConsumer());
            BuildTreeScopeServices buildTreeScopeServices = new BuildTreeScopeServices((ServiceRegistry)sessionScopeServices);
            ((BuildStateRegistry)buildTreeScopeServices.get(BuildStateRegistry.class)).attachRootBuild(build);
            return DefaultGradleLauncherFactory.this.doNewInstance(buildDefinition, build, this.parent, buildTreeScopeServices, (List)ImmutableList.of((Object)((Object)buildTreeScopeServices), (Object)((Object)sessionScopeServices), (Object)new Stoppable(){

                public void stop() {
                    DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.release(userHomeServices);
                }
            }));
        }

        private void setParent(DefaultGradleLauncher parent) {
            this.parent = parent;
        }

        private void setBuildCancellationToken(BuildCancellationToken buildCancellationToken) {
            this.buildCancellationToken = buildCancellationToken;
        }
    }
}

