/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java.usagecontext;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.java.usagecontext.ConfigurationVariantDetailsInternal;
import org.gradle.api.internal.java.usagecontext.FeatureConfigurationUsageContext;
import org.gradle.internal.Actions;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.SingleMessageLogger;

public class ConfigurationVariantMapping {
    private final ConfigurationInternal outgoingConfiguration;
    private Action<? super ConfigurationVariantDetails> action;
    private final Instantiator instantiator;

    public ConfigurationVariantMapping(ConfigurationInternal outgoingConfiguration, Action<? super ConfigurationVariantDetails> action, Instantiator instantiator) {
        this.outgoingConfiguration = outgoingConfiguration;
        this.action = action;
        this.instantiator = instantiator;
    }

    private void assertNoDuplicateVariant(String name, Set<String> seen) {
        if (!seen.add(name)) {
            throw new InvalidUserDataException("Cannot add feature variant '" + name + "' as a variant with the same name is already registered");
        }
    }

    public void addAction(Action<? super ConfigurationVariantDetails> action) {
        this.action = Actions.composite((Action[])new Action[]{this.action, action});
    }

    public void collectUsageContexts(ImmutableCollection.Builder<UsageContext> outgoing) {
        if (!this.outgoingConfiguration.isTransitive()) {
            SingleMessageLogger.nagUserWith((String)"Publication ignores 'transitive = false' at configuration level.", (String)"", (String)"Consider using 'transitive = false' at the dependency level if you need this to be published.", (String)"", (DeprecatedFeatureUsage.Type)DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
        HashSet seen = Sets.newHashSet();
        ConfigurationVariant defaultConfigurationVariant = (ConfigurationVariant)this.instantiator.newInstance(DefaultConfigurationVariant.class, new Object[]{this.outgoingConfiguration});
        ConfigurationVariantDetailsInternal details = (ConfigurationVariantDetailsInternal)this.instantiator.newInstance(DefaultConfigurationVariantDetails.class, new Object[]{defaultConfigurationVariant});
        this.action.execute((Object)details);
        String outgoingConfigurationName = this.outgoingConfiguration.getName();
        if (details.shouldPublish()) {
            this.registerUsageContext(outgoing, seen, defaultConfigurationVariant, outgoingConfigurationName, details.getMavenScope(), details.isOptional());
        }
        NamedDomainObjectContainer extraVariants = this.outgoingConfiguration.getOutgoing().getVariants();
        for (ConfigurationVariant variant : extraVariants) {
            details = new DefaultConfigurationVariantDetails(variant);
            this.action.execute((Object)details);
            if (!details.shouldPublish()) continue;
            String name = outgoingConfigurationName + StringUtils.capitalize((String)variant.getName());
            this.registerUsageContext(outgoing, seen, variant, name, details.getMavenScope(), details.isOptional());
        }
    }

    private void registerUsageContext(ImmutableCollection.Builder<UsageContext> outgoing, Set<String> seen, ConfigurationVariant variant, String name, String scope, boolean optional) {
        this.assertNoDuplicateVariant(name, seen);
        outgoing.add((Object)new FeatureConfigurationUsageContext(name, (Configuration)this.outgoingConfiguration, variant, scope, optional));
    }

    static class DefaultConfigurationVariantDetails
    implements ConfigurationVariantDetailsInternal {
        private final ConfigurationVariant variant;
        private boolean skip = false;
        private String mavenScope = "compile";
        private boolean optional = false;

        public DefaultConfigurationVariantDetails(ConfigurationVariant variant) {
            this.variant = variant;
        }

        public ConfigurationVariant getConfigurationVariant() {
            return this.variant;
        }

        public void skip() {
            this.skip = true;
        }

        public void mapToOptional() {
            this.optional = true;
        }

        public void mapToMavenScope(String scope) {
            this.mavenScope = DefaultConfigurationVariantDetails.assertValidScope(scope);
        }

        private static String assertValidScope(String scope) {
            if ("compile".equals(scope = scope.toLowerCase()) || "runtime".equals(scope)) {
                return scope;
            }
            throw new InvalidUserCodeException("Invalid Maven scope '" + scope + "'. You must choose between 'compile' and 'runtime'");
        }

        @Override
        public boolean shouldPublish() {
            return !this.skip;
        }

        @Override
        public String getMavenScope() {
            return this.mavenScope;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }
    }

    static class DefaultConfigurationVariant
    implements ConfigurationVariant {
        private final ConfigurationInternal outgoingConfiguration;

        public DefaultConfigurationVariant(ConfigurationInternal outgoingConfiguration) {
            this.outgoingConfiguration = outgoingConfiguration;
        }

        public PublishArtifactSet getArtifacts() {
            return this.outgoingConfiguration.getArtifacts();
        }

        public void artifact(Object notation) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        public String getName() {
            return this.outgoingConfiguration.getName();
        }

        public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
            throw new InvalidUserCodeException("Cannot mutate outgoing configuration during filtering");
        }

        public AttributeContainer getAttributes() {
            this.outgoingConfiguration.preventFromFurtherMutation();
            return this.outgoingConfiguration.getAttributes();
        }
    }
}

