/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.pgp;

import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRing;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpKeyId;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryFactory;
import org.gradle.util.ConfigureUtil;

public class InMemoryPgpSignatoryProvider
implements SignatoryProvider<PgpSignatory> {
    private final PgpSignatoryFactory factory = new PgpSignatoryFactory();
    private final Map<String, PgpSignatory> signatories = new LinkedHashMap<String, PgpSignatory>();
    private final String defaultKeyId;
    private final String defaultSecretKey;
    private final String defaultPassword;

    public InMemoryPgpSignatoryProvider(String defaultSecretKey, String defaultPassword) {
        this(null, defaultSecretKey, defaultPassword);
    }

    public InMemoryPgpSignatoryProvider(String defaultKeyId, String defaultSecretKey, String defaultPassword) {
        this.defaultKeyId = defaultKeyId;
        this.defaultSecretKey = defaultSecretKey;
        this.defaultPassword = defaultPassword;
    }

    @Override
    public PgpSignatory getDefaultSignatory(Project project) {
        if (this.defaultSecretKey != null && this.defaultPassword != null) {
            return this.createSignatory("default", this.defaultKeyId, this.defaultSecretKey, this.defaultPassword);
        }
        return null;
    }

    @Override
    public PgpSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    public PgpSignatory propertyMissing(String signatoryName) {
        return this.getSignatory(signatoryName);
    }

    @Override
    public void configure(SigningExtension settings, Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)new Object(){

            public void methodMissing(String name, Object args) {
                InMemoryPgpSignatoryProvider.this.createSignatoryFor(name, (Object[])DefaultGroovyMethods.asType((Object)args, Object[].class));
            }
        });
    }

    private void createSignatoryFor(String name, Object[] args) {
        String keyId = null;
        String secretKey = null;
        String password = null;
        switch (args.length) {
            case 2: {
                secretKey = args[0].toString();
                password = args[1].toString();
                break;
            }
            case 3: {
                keyId = args[0].toString();
                secretKey = args[1].toString();
                password = args[2].toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid args (" + name + ": " + Arrays.toString(args) + ")");
            }
        }
        this.signatories.put(name, this.createSignatory(name, keyId, secretKey, password));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PgpSignatory createSignatory(String name, String keyId, String secretKey, String password) {
        try (InputStream in = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(secretKey.getBytes(StandardCharsets.UTF_8)));){
            if (keyId == null) {
                PGPSecretKey key = new JcaPGPSecretKeyRing(in).getSecretKey();
                PgpSignatory pgpSignatory = this.factory.createSignatory(name, key, password);
                return pgpSignatory;
            }
            PgpKeyId expectedKeyId = new PgpKeyId(keyId);
            for (PGPSecretKeyRing keyring : new JcaPGPSecretKeyRingCollection(in)) {
                for (PGPSecretKey key : keyring) {
                    if (!expectedKeyId.equals(new PgpKeyId(key.getKeyID()))) continue;
                    PgpSignatory pgpSignatory = this.factory.createSignatory(name, key, password);
                    return pgpSignatory;
                }
            }
            PgpSignatory pgpSignatory = null;
            return pgpSignatory;
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Could not read PGP secret key", (Throwable)e);
        }
    }
}

